﻿using System;
using System.Web;
using System.Collections;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Web.Script.Services;
using AjaxControlToolkit;
using System.Data.SqlClient;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Collections.Generic;
using System.Collections.Specialized;

using BF.Bll;
using BF.Data;


/// <summary>
/// WebService 的摘要说明
/// </summary>
[WebService(Namespace = "http://bf.cn/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
[ScriptService()]
public class WebService : System.Web.Services.WebService
{

    public WebService()
    {

        //如果使用设计的组件，请取消注释以下行 
        //InitializeComponent(); 
    }

    [WebMethod]
    public string HelloWorld()
    {
        return "Hello World";
    }

    [WebMethod(Description = "查看是否存在此用户")]
    public bool ExistsUserName(string userName)
    {
        UserInfo userInfo = new UserInfo();
        return userInfo.Exists(userName);
    }

    [WebMethod(Description = "使用密码查看分类数据", CacheDuration = 300)]
    public string PasswordView(string urlKindID,string pwd)
    {
        UrlKind urlKind = new UrlKind();
        if (urlKind.CheckKindPwd(urlKindID, pwd))
        {
            Url url = new Url();
            DataTable dtUrl = url.GetDataByUrlKInd(urlKindID);
            if (dtUrl.Rows.Count == 0)
            {
                return "<div>该分类无数据</div>";
            }
            System.Text.StringBuilder sb = new System.Text.StringBuilder();
            foreach (DataRow rowUrl in dtUrl.Rows)
            {
                if (rowUrl["AllowShow"].ToString() == "1")
                    sb.AppendFormat("<li><a href=\"{0}\" target=\"_blank\" title=\"{1}\">{1}</a></li>\n", rowUrl["SiteUrl"].ToString(), rowUrl["SiteTitle"].ToString());
            }
            return sb.ToString();
        }
        else
        {
            return "PasswordError"; //返回错误信息
        }


    }

    //[WebMethod(Description = "获取广告代码", CacheDuration = 300)]
    //public string GetAd(string AdName)
    //{
    //    ////HttpContext.Current.Response.Expires = -1;
    //    //DBOperator db = DBOperator.Instance("ConnStr");
    //    //string sql = "Select Content From V_AdInfo where AdName = @AdName";
    //    //string[] param1 ={  "@AdName" };
    //    //object[] value1 ={  AdName };
    //    //return db.SearchValue(sql, param1, value1);

    //}
    //[WebMethod(Description = "获取广告代码", CacheDuration = 300)]
    //public string GetAd(string SiteName, string AdName)
    //{
    //    string result = "";
    //    OleDbConnection conn = new OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + System.Web.HttpContext.Current.Server.MapPath(
    //               ConfigurationManager.ConnectionStrings["AdConnStr"].ToString()));
    //    OleDbCommand cmd = new OleDbCommand("Select Content From V_AdInfo where SiteName=@SiteName and AdName = @AdName", conn);
    //    conn.Open();
    //    cmd.CommandType = CommandType.Text;
    //    OleDbParameter param1 = new OleDbParameter("@SiteName", SiteName);
    //    OleDbParameter param2 = new OleDbParameter("@AdName", AdName);
    //    cmd.Parameters.Add(param1);
    //    cmd.Parameters.Add(param2);
    //    //cmd.Prepare();
    //    OleDbDataReader dr = cmd.ExecuteReader();
    //    if (dr.Read())
    //    {
    //        result =  dr.GetString(0);
    //        if (dr != null)
    //            dr.Close();
    //    }
    //    conn.Close();
    //    return result;        
    //}

    



}
