﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Text;

using BF.Bll;
using BF.Common;
using BF.Web.Page;
public partial class Feedback_Default : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            if (Session["UserName"] == null || Session["UserName"].ToString() == "")
            {
                btnOk.Enabled = false;
                JsExe(upReplay, "no", "$('btn1').disabled = true;$('btn1').value = '登录后才能留言'");
            }
            ReadData();
        }
    }

    private void ReadData()
    {
        Feedback feedback = new Feedback();
        DataTable dt = feedback.GetAllData();
        AspNetPager1.RecordCount = dt.Rows.Count;
        rp1.DataSource = GetPagedData(dt, AspNetPager1.PageSize, GetCurrentPageIndex());
        rp1.DataBind();
    }

    protected void rp1_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {

    }

    protected string GetRevert(string id)
    {

        Feedback feedback = new Feedback();
        DataRow row = feedback.GetDataRow(id);
        if (row["revert"].ToString() == "")
            return "";
        else
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat("<div class=\"revert\" id=\"revert{0}\">", id);
            sb.AppendFormat("&nbsp;&nbsp;&nbsp;&nbsp;管理员于 {0} 回复", row["revertTime"].ToString());
            sb.AppendFormat("<br />{0}</div>", row["revert"].ToString());

            return sb.ToString();

        }

    }
    protected void btnOk_Click(object sender, EventArgs e)
    {
        Feedback feedback = new Feedback();
        if (txtTitle.Text.Trim() == "" || txtContnet.Text.Trim() == "") return;
        if (feedback.Insert(Server.HtmlEncode(txtTitle.Text), Server.HtmlEncode(txtContnet.Text), Session["UserName"].ToString(), Request.UserHostAddress, "1"))
        {
            lbMsg.Text = "留言成功！感谢您的支持！";
            txtTitle.Text = "";
            txtContnet.Text = "";
            ReadData();
            upList.Update();

        }

    }
}
