﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using BF.Common;
using BF.Web.Page;
using BF.Bll;

public partial class GetPassword :BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    protected void btnOk_Click(object sender, EventArgs e)
    {
        if (txtUserName.Text.Trim() == "" || txtEmail.Text.Trim() == "")
        {
            lbMsg.Text = "请填写资料！";
            return;
        }
        UserInfo userInfo = new UserInfo();
        DataRow row = userInfo.GetDataRow(txtUserName.Text.Trim());
        if (row == null)
        {
            lbMsg.Text = txtUserName.Text + " 这个用户名不存在！";
            return;
        }
        if (row["Email"].ToString() != txtEmail.Text.Trim())
        {
            lbMsg.Text = "您所填写的用户邮箱与您在本站登记的不一致，无法进行下一步操作。";
            return;
        }

        //发邮件
        EMail mail = new EMail();
        string newpwd = GetRandomPwd();

        if (mail.SendMail(txtEmail.Text, txtUserName.Text, "阿笨导航网会员密码变更通知",
            "您好，您的新密码已变更为&nbsp;" + newpwd + "&nbsp;。请尽快登录我们的<a href=\"http://ab0101.cn/UserLogin.aspx\">网站</a>修改密码!"))
        {
            userInfo.Update(txtUserName.Text.Trim(), Utils.MyEncrypt(newpwd), row["Email"].ToString());
            lbMsg.Text = "新密码已经发送到您的邮箱，请注意查收！";
            JsExe(upMain, "ok", "$('btn1').disabled = true;");
        }
        else
        {
            lbMsg.Text = "邮件发送失败，请稍后再试。";
        }
    }


    private string GetRandomPwd()
    {
        Random rd = new Random();
        return rd.Next(999999).ToString();
    }
}
