﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using BF.Common;
using BF.Bll;
using BF.Web.Page;
public partial class Register : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            txtValidateCode.Attributes.Add("onkeydown", "EnterToSubmit('btn1')");
        }
    }

    protected void btnOk_Click(object sender, EventArgs e)
    {        
        if (!CheckValidateCode(txtValidateCode.Text))
        {
            txtValidateCode.Text = "";
            lbMsg.Text = "验证码错误！";
            return;
        }

        UserInfo userInfo = new UserInfo();
        if (userInfo.Exists(txtUserName.Text))
        {
            lbMsg.Text = "用户名：" + txtUserName.Text + " 已被注册！";
            return;
        }
        if (userInfo.Insert(txtUserName.Text.Trim(), Utils.MyEncrypt(txtPassword.Text), txtEmail.Text))
        {
            HomePageConfig config = new HomePageConfig();
            config.Insert(txtUserName.Text.Trim(), txtUserName.Text.Trim() + "之家", "Baidu");
            SaveLoginStatus(txtUserName.Text.Trim());
            string str = string.Format("Success.aspx?Info={0}&Link={1}", Server.UrlEncode("<b>" + txtUserName.Text + "</b>，恭喜您成功注册成为本站会员！"), Server.UrlEncode("UserCenter"));
            Response.Redirect(str);
            
        }

    }
}
