﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;


using BF.Bll;
using BF.Web.Page;
public partial class UserCenter_UrlEdit : UsersPage
{

    //protected override void OnInit(EventArgs e)
    //{        
    //    if (Request.UrlReferrer != null && Request.UrlReferrer.IsLoopback == false)
    //    {
    //        Session["UrlReferrer"] = Request.UrlReferrer.OriginalString;    //保存来源地址
    //    }
    //    CheckLoginStatus();
    //}
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            ReadUrlKind();
            txtSN.Text = "0";
            txtSN.Attributes.Add("onkeydown", "EnterToSubmit('btn1')");
            if (Request.QueryString["action"] == "edit")
            {
                if (IsInt(Request.QueryString["id"]))
                    ReadData(Request.QueryString["id"]);
                else
                {
                    Response.Write("非法数据！");
                    Response.End();
                    return;
                }
                ltBack.Visible = true;
            }
            else
            {
                if (Session["UrlReferrer"] != null && Session["UrlReferrer"].ToString() != "")
                {
                    txtSiteUrl.Text = Session["UrlReferrer"].ToString();
                    Session.Remove("UrlReferrer");  //清除
                }
            }
        }
    }

    /// <summary>
    /// 读取分类数据到Drp
    /// </summary>
    private void ReadUrlKind()
    {
        UrlKind urlKind = new UrlKind();
        ListItem[] lts = urlKind.GetListItemByOwnerUser(Session["UserName"].ToString());
        dwUrlKindID.Items.Add(new ListItem());
        dwUrlKindID.Items.AddRange(lts);
    }

    /// <summary>
    /// 读取该分类数据信息
    /// </summary>
    /// <param name="id"></param>
    private void ReadData(string id)
    {
        Url url = new Url();
        DataRow row = url.GetDataRow(id);
        txtSiteTitle.Text = row["SiteTitle"].ToString();
        txtSiteUrl.Text = row["SiteUrl"].ToString();
        dwUrlKindID.Text = row["UrlKindID"].ToString();
        txtSN.Text = row["SN"].ToString();
    }

    protected void btnOk_Click(object sender, EventArgs e)
    {
        Url url = new Url();
        if (Request.QueryString["action"] == "edit")
        {
            if (url.Update(txtSiteUrl.Text,txtSiteTitle.Text,dwUrlKindID.Text,txtSN.Text, Request.QueryString["id"]))
            {
                lbMsg.Text = "更新数据成功！";
                JsExe(upMain, "dd", "$('btn1').disabled = true;");
                CacheRemove("Url"); //刷新缓存
            }
        }
        else
        {
            if (url.Insert(txtSiteUrl.Text, txtSiteTitle.Text, dwUrlKindID.Text, txtSN.Text))
            {
                lbMsg.Text = "新增网址成功！";
                JsExe(upMain, "dd", "$('btn1').disabled = true;");
                CacheRemove("Url"); //刷新缓存
            }
        }
    }
}
