﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;


using BF.Bll;
using BF.Web.Page;
public partial class UserCenter_UrlKindEdit : UsersPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            txtSN.Text = "0";
            txtSN.Attributes.Add("onkeydown", "EnterToSubmit('btn1')");
            if (Request.QueryString["action"] == "edit")
            {                
                ltBack.Visible = true;
                if (IsInt(Request.QueryString["id"]))
                    ReadData(Request.QueryString["id"]);
                else
                {
                    Response.Write("非法数据！");
                    Response.End();
                    return;
                }
            }
            if (Request.UrlReferrer.AbsolutePath.ToLower() == "/usercenter/urledit.aspx")
            {
                ltBack.Visible = true;
            }
        }
    }


    /// <summary>
    /// 读取该分类数据信息
    /// </summary>
    /// <param name="id"></param>
    private void ReadData(string id)
    {
        UrlKind urlKind = new UrlKind();
        DataRow row = urlKind.GetDataRow(id);
        txtName.Text = row["Name"].ToString();
        txtSN.Text = row["SN"].ToString();
        txtVisitPwd.Text = row["VisitPwd"].ToString();
        dwSkin.Text = row["Skin"].ToString();
    }

    protected void btnOk_Click(object sender, EventArgs e)
    {
        UrlKind urlKind = new UrlKind();
        if (Request.QueryString["action"] == "edit")
        {
            if (urlKind.Update(txtName.Text.Trim(), dwSkin.Text, txtVisitPwd.Text, txtSN.Text, Request.QueryString["id"]))
            {
                lbMsg.Text = "更新数据成功！";
                JsExe(upMain, "dd", "$('btn1').disabled = true;");
                CacheRemove("UrlKind"); //刷新缓存
            }
        }
        else
        {
            if (urlKind.Insert(txtName.Text.Trim(), dwSkin.Text, txtVisitPwd.Text, txtSN.Text, Session["UserName"].ToString()))
            {                
                lbMsg.Text = "新增分类成功！";
                JsExe(upMain, "dd", "$('btn1').disabled = true;");
                CacheRemove("UrlKind"); //刷新缓存
            }
        }
    }
}
