﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;


using BF.Bll;
using BF.Web.Page;
public partial class UserCenter_UrlKindManager : UsersPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            CacheRemove("UrlKind");
            BindData();
        }
    }

    private void BindData()
    {
        DataTable dtAll = GetCacheData("UrlKind") as DataTable;
        if (dtAll == null)
        {

            UrlKind urlKind = new UrlKind();
            dtAll = urlKind.GetDataByOwnerUser(Session["UserName"].ToString());
            AspNetPager1.RecordCount = dtAll.Rows.Count;
            CacheData("UrlKind", dtAll, 5);
        }
        gv1.DataSource = GetPagedData(dtAll, AspNetPager1.PageSize, AspNetPager1.CurrentPageIndex);
        gv1.DataBind();
    }

    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        BindData();
    }


    protected void gv1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        UrlKind urlKind = new UrlKind();

        if (urlKind.GetUrlCount(gv1.Rows[e.RowIndex].Cells[0].Text.Trim()) > 0)
        {
            Alert(upMain, "no", "该分类下存在数据，请处理好后再进行该操作！");
            return;
        }

        if (urlKind.Delete(gv1.Rows[e.RowIndex].Cells[0].Text.Trim()))
        {
            CacheRemove("UrlKind");
            BindData();
        }
    }

    /// <summary>
    /// 取得该分类下的网址数
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    protected string GetUrlCount(string id)
    {
        UrlKind urlKind = new UrlKind();
        return urlKind.GetUrlCount(id).ToString();
    }

    protected string GetSkin(string skin)
    {
        string skinName = "";
        switch (skin)
        {
            case "1":
                skinName = "<span style='color:#0092ec'>蓝色</span>";
                break;
            case "2":
                skinName = "<span style='color:#2fc300'>绿色</span>";
                break;
            case "3":
                skinName = "<span style='color:#f36a01'>橙色</span>";
                break;
            default:
                break;
        }
        return skinName;
    }
}
