﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;


using BF.Bll;
using BF.Web.Page;
using BF.Common;
public partial class UserCenter_UrlManager : UsersPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            CacheRemove("Url");
            ReadUrlKind();
            BindData();
            Response.Write("<script></script>");
        }
    }
    /// <summary>
    /// 读取分类
    /// </summary>
    private void ReadUrlKind()
    {
        UrlKind urlKind = new UrlKind();
        ListItem[] lts = urlKind.GetListItemByOwnerUser(Session["UserName"].ToString());

        if (lts.Length == 0)
        {
            lbxKind.Items.Add(new ListItem("没有任何分类", "0"));
            lbxKind.Items[0].Selected = true;
            return;
        }
        lbxKind.Items.AddRange(lts);
        
        ListItem[] lts2 = new ListItem[lts.Length];
        lts.CopyTo(lts2, 0);
        dwToKind.Items.Add(new ListItem("=请选择新分类=",""));
        dwToKind.Items.AddRange(lts2);        
        lbxKind.Items[0].Selected = true;
        
    }

    private void BindData()
    {
        DataTable dtAll = GetCacheData("Url") as DataTable;
        if (dtAll == null)
        {

            Url url = new Url();
            dtAll = url.GetDataByUrlKInd(lbxKind.SelectedItem.Value);
            AspNetPager1.RecordCount = dtAll.Rows.Count;
            CacheData("Url", dtAll, 5);
        }
        gv1.DataSource = GetPagedData(dtAll, AspNetPager1.PageSize, AspNetPager1.CurrentPageIndex);
        gv1.DataBind();
        upList.Update();
    }

    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        BindData();
    }

    protected void btnOk_Click(object sender, EventArgs e)
    {
        string action = Request.Form["dw_Action"];
        string[] ids = Request.Form.GetValues("id");
        string idlist = Utils.ArrToStr(ids, ",");
        if (idlist == "") return;

        Url url = new Url();
        switch (action)
        {
            case "allow":
                url.ChangeStatus(idlist, "1");
                break;
            case "disabled":
                url.ChangeStatus(idlist,"0");
                break;
            case "del":
                url.BatchDelete(idlist);
                break;
            case "tokind":
                url.ChangeUrlKind(idlist, dwToKind.Text);
                break;
            default:
                break;
        }

        CacheRemove("Url");
        BindData();          
    }

    protected void lbxKind_SelectedIndexChanged(object sender, EventArgs e)
    {
        CacheRemove("Url");
        BindData();        
    }

    protected string GetStatus(string status)
    {
        if (status == "1")
        {
            return "<span style='color:#009900'>允许</span>";
        }
        else
        {
            return "<span style='color:#ff0000'>禁止</span>";
        }
    }
}
