﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using BF.Common;
using BF.Bll;
using BF.Web.Page;
public partial class UserLogin : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //退出登录
            if (Request.QueryString["action"] == "logout")
            {
                Session.Clear();
                Request.Cookies.Clear();
                ClearLoginStatu();
            }
            Utils.EnterToTab(txtUserName);
            Utils.EnterToSubmit(txtPassword, "btn1");
        }

    }
    protected void btnOk_Click(object sender, EventArgs e)
    {
        string userName = Utils.ChkSQL(txtUserName.Text.Trim());
        string userPwd = Utils.MyEncrypt(txtPassword.Text);
        UserInfo userInfo = new UserInfo();
        if (!userInfo.CheckLogin(userName, userPwd))
        {
            lbMsg.Text = "登录密码错误，请重新输入";
            return;
        }
        else
        {
            if (ckbSaveMe.Checked)
            {
                SaveLoginStatus(userName, userPwd, 365);    //保存到Cookies一年
            }
            else
            {
                SaveLoginStatus(userName);
            }
            string link = Server.UrlEncode("UserCenter");
            if (Session["UrlReferrer"] != null) link = Server.UrlEncode("/UserCenter/#3");
            string str = string.Format("Success.aspx?Info={0}&Link={1}", Server.UrlEncode("<b>" + txtUserName.Text + "</b>，欢迎您再次登录！"), link);
            Response.Redirect(str);

        }
    }
}
