<?php
 namespace Module\Doc\Api\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\IdUtil; use Module\Doc\Util\DocCategoryUtil; use Module\Member\Auth\MemberUser; use Module\Member\Support\MemberLoginCheck; class DocCategoryController extends Controller implements MemberLoginCheck { public function all() { return Response::generateSuccessData(DocCategoryUtil::all(MemberUser::id())); } public function edit() { $input = InputPackage::buildFromInput(); $uid = $input->getTrimString('uid'); $data = []; $data['parentUid'] = $input->getTrimString('parentUid'); $data['sort'] = $input->getInteger('sort'); $data['name'] = $input->getTrimString('name'); $data['color'] = $input->getTrimString('color'); if ($uid) { ModelUtil::update('doc_category', ['memberUserId' => MemberUser::id(), 'uid' => $uid], $data); } else { $data['uid'] = IdUtil::next64BitId(); $data['memberUserId'] = MemberUser::id(); $data['sort'] = intval(ModelUtil::max('doc_category', 'sort', ['memberUserId' => MemberUser::id()])) + 1; ModelUtil::insert('doc_category', $data); } return Response::generateSuccess(); } public function editBatch() { $input = InputPackage::buildFromInput(); $list = $input->getArray('list'); foreach ($list as $item) { $itemInput = InputPackage::build($item); $uid = $itemInput->getTrimString('uid'); $data = []; $data['parentUid'] = $itemInput->getTrimString('parentUid'); $data['sort'] = $itemInput->getInteger('sort'); $data['name'] = $itemInput->getTrimString('name'); $data['color'] = $itemInput->getTrimString('color'); ModelUtil::update('doc_category', $data, ['memberUserId' => MemberUser::id(), 'uid' => $uid]); } return Response::generateSuccess(); } public function delete() { $input = InputPackage::buildFromInput(); $uid = $input->getTrimString('uid'); ModelUtil::delete('doc_category', ['memberUserId' => MemberUser::id(), 'uid' => $uid]); return Response::generateSuccess(); } }