<?php
 namespace Module\Doc\Api\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\IdUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TagUtil; use Module\Doc\Type\DocType; use Module\Doc\Type\DocVisit; use Module\Doc\Util\DocTagUtil; use Module\Member\Auth\MemberUser; use Module\Member\Support\MemberLoginCheck; class DocController extends Controller implements MemberLoginCheck { public function paginate() { $input = InputPackage::buildFromInput(); $searchInput = $input->getAsInput('search'); $option = [ 'order' => ['updated_at', 'desc'], 'where' => [ 'memberUserId' => MemberUser::id(), ], 'whereOperate' => [], 'fields' => ['id', 'created_at', 'updated_at', 'title', 'summary', 'type', 'uid', 'categoryUid', 'tagUids'] ]; if ($category = $searchInput->getTrimString('category')) { $option['where']['categoryUid'] = $category; } if ($tag = $searchInput->getTrimString('tag')) { $option['whereOperate'][] = ['tagUids', 'like', "%:$tag:%"]; } if ($keywords = $searchInput->getTrimString('keywords')) { $option['whereOperate'][] = ['title', 'like', "%$keywords%"]; } $paginateData = ModelUtil::paginate('doc', $input->getPage(), $input->getPageSize(), $option); foreach ($paginateData['records'] as $i => $item) { $paginateData['records'][$i]['tagUids'] = TagUtil::string2Array($item['tagUids']); } return Response::generateSuccessPaginate($input->getPage(), $input->getPageSize(), $paginateData); } public function get() { $input = InputPackage::buildFromInput(); $uid = $input->getTrimString('uid'); $doc = ModelUtil::get('doc', ['uid' => $uid, 'memberUserId' => MemberUser::id()]); if ($doc) { $doc['tagUids'] = TagUtil::string2Array($doc['tagUids'], 'string'); } return Response::generateSuccessData($doc); } public function edit() { $input = InputPackage::buildFromInput(); $uid = $input->getTrimString('uid'); $data = []; $data['title'] = $input->getTrimString('title'); $data['categoryUid'] = $input->getTrimString('categoryUid'); $data['tagUids'] = TagUtil::array2String($input->getArray('tagUids')); $data['content'] = $input->getTrimString('content'); $data['type'] = $input->getType('type', DocType::class); if ($uid) { $exists = ModelUtil::get('doc', ['memberUserId' => MemberUser::id(), 'uid' => $uid]); if (!$exists) { return Response::generateError('doc not exists'); } $alias = $exists['alias']; $oldDoc = ModelUtil::first('doc_history', ['docUid' => $uid], ['*'], ['id', 'desc']); $docHistoryData = [ 'docUid' => $uid, 'content' => $data['content'], ]; if (empty($oldDoc)) { ModelUtil::insert('doc_history', $docHistoryData); } else { if (strlen($data['content']) - similar_text($oldDoc['content'], $data['content']) > 10) { ModelUtil::insert('doc_history', $docHistoryData); } } ModelUtil::update('doc', ['memberUserId' => MemberUser::id(), 'uid' => $uid], $data); } else { $data['alias'] = RandomUtil::lowerString(20); $data['uid'] = IdUtil::next64BitId(); $data['memberUserId'] = MemberUser::id(); $data['visit'] = DocVisit::VISIT_PRIVATE; ModelUtil::insert('doc', $data); $uid = $data['uid']; $alias = $data['alias']; } return Response::generateSuccessData([ 'uid' => $uid, 'alias' => $alias, ]); } public function setting() { $input = InputPackage::buildFromInput(); $uid = $input->getTrimString('uid'); $data = []; $data['visit'] = $input->getType('visit', DocVisit::class); $data['visitPassword'] = $input->getTrimString('visitPassword'); $data['attrIcon'] = $input->getImagePath('attrIcon'); $data['attrSubTitle'] = $input->getTrimString('attrSubTitle'); $data['attrSummary'] = $input->getTrimString('attrSummary'); ModelUtil::update('doc', ['memberUserId' => MemberUser::id(), 'uid' => $uid], $data); return Response::generateSuccess(); } public function publish() { $input = InputPackage::buildFromInput(); $uid = $input->getTrimString('uid'); $exists = ModelUtil::get('doc', ['memberUserId' => MemberUser::id(), 'uid' => $uid]); if (!$exists) { return Response::generateError('doc not exists'); } $data = []; $data['contentPublished'] = $exists['content']; $data['contentPublishedPreview'] = $input->getTrimString('contentPublishedPreview'); ModelUtil::update('doc', ['memberUserId' => MemberUser::id(), 'uid' => $uid], $data); return Response::generateSuccess(); } public function delete() { $input = InputPackage::buildFromInput(); $uid = $input->getTrimString('uid'); ModelUtil::delete('doc', ['memberUserId' => MemberUser::id(), 'uid' => $uid]); return Response::generateSuccess(); } }