<?php
 namespace Module\Doc\Api\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use Module\Doc\Util\DocUtil; use Module\Member\Auth\MemberUser; use Module\Member\Support\MemberLoginCheck; class DocHistoryController extends Controller implements MemberLoginCheck { public function paginate() { $input = InputPackage::buildFromInput(); $uid = $input->getTrimString('uid'); $doc = DocUtil::get(MemberUser::id(), $uid); if (!$doc) { return Response::generateError('doc not exists'); } $option = [ 'order' => ['id', 'desc'], 'where' => [ 'docUid' => $uid, ], 'whereOperate' => [], 'fields' => ['id', 'created_at',] ]; $paginateData = ModelUtil::paginate('doc_history', $input->getPage(), $input->getPageSize(), $option); return Response::generateSuccessPaginate($input->getPage(), $input->getPageSize(), $paginateData); } public function get() { $input = InputPackage::buildFromInput(); $id = $input->getInteger('id'); $docHistory = ModelUtil::get('doc_history', ['id' => $id]); if (!$docHistory) { return Response::generateError('doc history not exists'); } if (!DocUtil::get(MemberUser::id(), $docHistory['docUid'])) { return Response::generateError('doc not exists'); } return Response::generateSuccessData($docHistory); } }