<?php
 namespace Module\Doc\Web\Controller; use Illuminate\Support\Facades\Session; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Module\ModuleBaseController; use Module\Doc\Type\DocType; use Module\Doc\Type\DocVisit; class DocViewController extends ModuleBaseController { public function old($alias) { return Response::redirect(modstart_web_url("d/$alias")); } public function index($alias, $file = null) { $input = InputPackage::buildFromInput(); $doc = ModelUtil::get('doc', ['alias' => $alias]); if (empty($doc)) { return Response::send(-1, '文档不存在', null, '/'); } switch ($doc['visit']) { case DocVisit::VISIT_PRIVATE: return Response::send(-1, '您访问的文档为私密文档'); case DocVisit::VISIT_PUBLIC: break; case DocVisit::VISIT_PASSWORD: $docPasswordKey = 'docVisitPassword-' . substr(md5($doc['visitPassword']), 0, 10) . '-' . $doc['id']; if (Request::isPost()) { $password = $input->getTrimString('password'); if ($doc['visitPassword'] != $password) { return Response::send(-1, '密码不正确'); } Session::put($docPasswordKey, true); return Response::send(0, null, null, '[reload]'); } if (!Session::get($docPasswordKey, false)) { return $this->view('docView.password', [ 'doc' => $doc, ]); } } switch ($doc['type']) { case DocType::MARKDOWN: return $this->viewMarkdown($doc, $file); case DocType::RICH: return $this->viewRich($doc, $file); case DocType::MIND: return $this->viewMind($doc, $file); case DocType::GRAPH: return $this->viewGraph($doc, $file); } } private function viewMarkdown($doc, $file) { switch ($file) { case '_coverpage.md': return $this->view('docView.markdownCoverpage', ['doc' => $doc]); case 'README.md': return $doc['contentPublishedPreview']; default: return $this->view('docView.markdown', [ 'doc' => $doc, ]); } } private function viewRich($doc, $file) { return $this->view('docView.rich', [ 'doc' => $doc, ]); } private function viewGraph($doc, $file) { return $this->view('docView.graph', [ 'doc' => $doc, ]); } private function viewMind($doc, $file) { return $this->view('docView.mind', [ 'doc' => $doc, ]); } }