<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>登录处理中</title>
</head>

<body>
<script>
    var OauthProxy = {
        version: '1.1.1',
        urlParams: {},
        // appendParams: function(url, params) {
        //     if (params) {
        //         var baseWithSearch = url.split('#')[0];
        //         var hash = url.split('#')[1];
        //         for (var key in params) {
        //             var attrValue = params[key];
        //             if (attrValue !== undefined) {
        //                 var newParam = key + "=" + attrValue;
        //                 if (baseWithSearch.indexOf('?') > 0) {
        //                     var oldParamReg = new RegExp('^' + key + '=[-%.!~*\'\(\)\\w]*', 'g');
        //                     if (oldParamReg.test(baseWithSearch)) {
        //                         baseWithSearch = baseWithSearch.replace(oldParamReg, newParam);
        //                     } else {
        //                         baseWithSearch += "&" + newParam;
        //                     }
        //                 } else {
        //                     baseWithSearch += "?" + newParam;
        //                 }
        //             }
        //         }
        //         if (hash) {
        //             url = baseWithSearch + '#' + hash;
        //         } else {
        //             url = baseWithSearch;
        //         }
        //     }
        //     return url;
        // },
        parseUrl: function (url) {
            url = url || window.location.href;
            var parser = document.createElement("a");
            parser.href = url;
            var param = {};
            var pairs = (parser.search || '?').substring(1).split('&');
            for (var i = 0; i < pairs.length; i++) {
                var pos = pairs[i].indexOf('=');
                if (pos === -1) {
                    continue;
                }
                param[pairs[i].substring(0, pos)] = decodeURIComponent(pairs[i].substring(pos + 1));
            }
            return {
                protocol: parser.protocol,
                host: parser.host,
                hostname: parser.hostname,
                port: parser.port,
                pathname: parser.pathname,
                hash: parser.hash,
                search: parser.search,
                origin: parser.origin,
                param: param,
            };
        },
        joinUrl: function (urlInfo) {
            var part = [];
            part.push(urlInfo.origin);
            part.push(urlInfo.pathname);
            part.push('?');
            var param = [];
            for (var k in urlInfo.param) {
                param.push(encodeURIComponent(k) + '=' + encodeURIComponent(urlInfo.param[k]));
            }
            part.push(param.join('&'));
            if (urlInfo.hash) {
                part.push(urlInfo.hash);
            }
            return part.join('');
        },
        doProcess: function () {
            var proxyInfo = OauthProxy.parseUrl();
            console.log('urlInfo', proxyInfo);
            var proxy = proxyInfo.param['_proxy'] || '';
            if (proxy) {
                var targetInfo = OauthProxy.parseUrl(proxy);
                for (var k in ['redirect_uri']) {
                    if (k in targetInfo.param) {
                        targetInfo.param[k] = proxyInfo.origin + proxyInfo.pathname;
                    }
                }
                var fullUrl = OauthProxy.joinUrl(targetInfo);
                // window.location.href = fullUrl;
                console.log('redirect', fullUrl);
            }
            return;
            var code = proxyInfo['code'];
            var appId = proxyInfo['appid'];
            var scope = proxyInfo['scope'] || 'snsapi_base';
            var state = proxyInfo['state'];
            var component_appid = proxyInfo['component_appid'] || '';
            var redirectUri;
            var proxyType = proxyInfo['proxy_type'] || '';

            if (!code) {
                //第一步，没有拿到code，跳转至微信授权页面获取code
                if (proxyType == 'pc') {
                    redirectUri = OauthProxy.appendParams('https://open.weixin.qq.com/connect/qrconnect', {
                        'appid': appId,
                        'redirect_uri': encodeURIComponent(location.href),
                        'response_type': 'code',
                        'scope': scope,
                        'state': state,
                    });
                } else if (component_appid) {
                    redirectUri = OauthProxy.appendParams('https://open.weixin.qq.com/connect/oauth2/authorize#wechat_redirect', {
                        'appid': appId,
                        'redirect_uri': encodeURIComponent(location.href),
                        'response_type': 'code',
                        'scope': scope,
                        'state': state,
                        'component_appid': component_appid,
                    });
                } else {
                    redirectUri = OauthProxy.appendParams('https://open.weixin.qq.com/connect/oauth2/authorize#wechat_redirect', {
                        'appid': appId,
                        'redirect_uri': encodeURIComponent(location.href),
                        'response_type': 'code',
                        'scope': scope,
                        'state': state,
                    });
                }
            } else {
                //第二步，从微信授权页面跳转回来，已经获取到了code，再次跳转到实际所需页面
                redirectUri = OauthProxy.appendParams(proxyInfo['redirect_uri'], {
                    'code': code,
                    'state': state
                });
            }

            location.href = redirectUri;
        }
    };
    OauthProxy.doProcess();
</script>
</body>

</html>
