const {src, dest, parallel, series} = require('gulp')
const concat = require('gulp-concat')
const uglify = require('gulp-uglify')

function editor() {
    return src([
        'mxgraph/js/util/mxLog.js',
        'mxgraph/js/util/mxObjectIdentity.js',
        'mxgraph/js/util/mxDictionary.js',
        'mxgraph/js/util/mxResources.js',
        'mxgraph/js/util/mxPoint.js',
        'mxgraph/js/util/mxRectangle.js',
        'mxgraph/js/util/mxEffects.js',
        'mxgraph/js/util/mxUtils.js',
        'mxgraph/js/util/mxConstants.js',
        'mxgraph/js/util/mxEventObject.js',
        'mxgraph/js/util/mxMouseEvent.js',
        'mxgraph/js/util/mxEventSource.js',
        'mxgraph/js/util/mxEvent.js',
        'mxgraph/js/util/mxXmlRequest.js',
        'mxgraph/js/util/mxClipboard.js',
        'mxgraph/js/util/mxWindow.js',
        'mxgraph/js/util/mxForm.js',
        'mxgraph/js/util/mxImage.js',
        'mxgraph/js/util/mxDivResizer.js',
        'mxgraph/js/util/mxDragSource.js',
        'mxgraph/js/util/mxToolbar.js',
        'mxgraph/js/util/mxUndoableEdit.js',
        'mxgraph/js/util/mxUndoManager.js',
        'mxgraph/js/util/mxUrlConverter.js',
        'mxgraph/js/util/mxPanningManager.js',
        'mxgraph/js/util/mxPopupMenu.js',
        'mxgraph/js/util/mxAutoSaveManager.js',
        'mxgraph/js/util/mxAnimation.js',
        'mxgraph/js/util/mxMorphing.js',
        'mxgraph/js/util/mxImageBundle.js',
        'mxgraph/js/util/mxImageExport.js',
        'mxgraph/js/util/mxAbstractCanvas2D.js',
        'mxgraph/js/util/mxXmlCanvas2D.js',
        'mxgraph/js/util/mxSvgCanvas2D.js',
        'mxgraph/js/util/mxVmlCanvas2D.js',
        'mxgraph/js/util/mxGuide.js',
        'mxgraph/js/shape/mxShape.js',
        'mxgraph/js/shape/mxStencil.js',
        'mxgraph/js/shape/mxStencilRegistry.js',
        'mxgraph/js/shape/mxMarker.js',
        'mxgraph/js/shape/mxActor.js',
        'mxgraph/js/shape/mxCloud.js',
        'mxgraph/js/shape/mxRectangleShape.js',
        'mxgraph/js/shape/mxEllipse.js',
        'mxgraph/js/shape/mxDoubleEllipse.js',
        'mxgraph/js/shape/mxRhombus.js',
        'mxgraph/js/shape/mxPolyline.js',
        'mxgraph/js/shape/mxArrow.js',
        'mxgraph/js/shape/mxArrowConnector.js',
        'mxgraph/js/shape/mxText.js',
        'mxgraph/js/shape/mxTriangle.js',
        'mxgraph/js/shape/mxHexagon.js',
        'mxgraph/js/shape/mxLine.js',
        'mxgraph/js/shape/mxImageShape.js',
        'mxgraph/js/shape/mxLabel.js',
        'mxgraph/js/shape/mxCylinder.js',
        'mxgraph/js/shape/mxConnector.js',
        'mxgraph/js/shape/mxSwimlane.js',
        'mxgraph/js/layout/mxGraphLayout.js',
        'mxgraph/js/layout/mxStackLayout.js',
        'mxgraph/js/layout/mxPartitionLayout.js',
        'mxgraph/js/layout/mxCompactTreeLayout.js',
        'mxgraph/js/layout/mxRadialTreeLayout.js',
        'mxgraph/js/layout/mxFastOrganicLayout.js',
        'mxgraph/js/layout/mxCircleLayout.js',
        'mxgraph/js/layout/mxParallelEdgeLayout.js',
        'mxgraph/js/layout/mxCompositeLayout.js',
        'mxgraph/js/layout/mxEdgeLabelLayout.js',
        'mxgraph/js/layout/hierarchical/model/mxGraphAbstractHierarchyCell.js',
        'mxgraph/js/layout/hierarchical/model/mxGraphHierarchyNode.js',
        'mxgraph/js/layout/hierarchical/model/mxGraphHierarchyEdge.js',
        'mxgraph/js/layout/hierarchical/model/mxGraphHierarchyModel.js',
        'mxgraph/js/layout/hierarchical/model/mxSwimlaneModel.js',
        'mxgraph/js/layout/hierarchical/stage/mxHierarchicalLayoutStage.js',
        'mxgraph/js/layout/hierarchical/stage/mxMedianHybridCrossingReduction.js',
        'mxgraph/js/layout/hierarchical/stage/mxMinimumCycleRemover.js',
        'mxgraph/js/layout/hierarchical/stage/mxCoordinateAssignment.js',
        'mxgraph/js/layout/hierarchical/stage/mxSwimlaneOrdering.js',
        'mxgraph/js/layout/hierarchical/mxHierarchicalLayout.js',
        'mxgraph/js/layout/hierarchical/mxSwimlaneLayout.js',
        'mxgraph/js/model/mxGraphModel.js',
        'mxgraph/js/model/mxCell.js',
        'mxgraph/js/model/mxGeometry.js',
        'mxgraph/js/model/mxCellPath.js',
        'mxgraph/js/view/mxPerimeter.js',
        'mxgraph/js/view/mxPrintPreview.js',
        'mxgraph/js/view/mxStylesheet.js',
        'mxgraph/js/view/mxCellState.js',
        'mxgraph/js/view/mxGraphSelectionModel.js',
        'mxgraph/js/view/mxCellEditor.js',
        'mxgraph/js/view/mxCellRenderer.js',
        'mxgraph/js/view/mxEdgeStyle.js',
        'mxgraph/js/view/mxStyleRegistry.js',
        'mxgraph/js/view/mxGraphView.js',
        'mxgraph/js/view/mxGraph.js',
        'mxgraph/js/view/mxCellOverlay.js',
        'mxgraph/js/view/mxOutline.js',
        'mxgraph/js/view/mxMultiplicity.js',
        'mxgraph/js/view/mxLayoutManager.js',
        'mxgraph/js/view/mxSwimlaneManager.js',
        'mxgraph/js/view/mxTemporaryCellStates.js',
        'mxgraph/js/view/mxCellStatePreview.js',
        'mxgraph/js/view/mxConnectionConstraint.js',
        'mxgraph/js/handler/mxGraphHandler.js',
        'mxgraph/js/handler/mxPanningHandler.js',
        'mxgraph/js/handler/mxPopupMenuHandler.js',
        'mxgraph/js/handler/mxCellMarker.js',
        'mxgraph/js/handler/mxSelectionCellsHandler.js',
        'mxgraph/js/handler/mxConnectionHandler.js',
        'mxgraph/js/handler/mxConstraintHandler.js',
        'mxgraph/js/handler/mxRubberband.js',
        'mxgraph/js/handler/mxHandle.js',
        'mxgraph/js/handler/mxVertexHandler.js',
        'mxgraph/js/handler/mxEdgeHandler.js',
        'mxgraph/js/handler/mxElbowEdgeHandler.js',
        'mxgraph/js/handler/mxEdgeSegmentHandler.js',
        'mxgraph/js/handler/mxKeyHandler.js',
        'mxgraph/js/handler/mxTooltipHandler.js',
        'mxgraph/js/handler/mxCellTracker.js',
        'mxgraph/js/handler/mxCellHighlight.js',
        'mxgraph/js/editor/mxDefaultKeyHandler.js',
        'mxgraph/js/editor/mxDefaultPopupMenu.js',
        'mxgraph/js/editor/mxDefaultToolbar.js',
        'mxgraph/js/editor/mxEditor.js',
        'mxgraph/js/io/mxCodecRegistry.js',
        'mxgraph/js/io/mxCodec.js',
        'mxgraph/js/io/mxObjectCodec.js',
        'mxgraph/js/io/mxCellCodec.js',
        'mxgraph/js/io/mxModelCodec.js',
        'mxgraph/js/io/mxRootChangeCodec.js',
        'mxgraph/js/io/mxChildChangeCodec.js',
        'mxgraph/js/io/mxTerminalChangeCodec.js',
        'mxgraph/js/io/mxGenericChangeCodec.js',
        'mxgraph/js/io/mxGraphCodec.js',
        'mxgraph/js/io/mxGraphViewCodec.js',
        'mxgraph/js/io/mxStylesheetCodec.js',
        'mxgraph/js/io/mxDefaultKeyHandlerCodec.js',
        'mxgraph/js/io/mxDefaultToolbarCodec.js',
        'mxgraph/js/io/mxDefaultPopupMenuCodec.js',
        'mxgraph/js/io/mxEditorCodec.js',

    ], {sourcemaps: false})
        .pipe(concat('mxgraph.all.min.js'))
        .pipe(uglify())
        .pipe(dest('mxgraph/js', {sourcemaps: false}))
}

function pre() {
    return src([
        'js/Init.js',
        'deflate/pako.min.js',
        'deflate/base64.js',
        'jscolor/jscolor.js',
        'sanitizer/sanitizer.min.js',
    ], {sourcemaps: false})
        .pipe(concat('pre.min.js'))
        .pipe(uglify())
        .pipe(dest('./', {sourcemaps: false}))
}

function all() {
    return src([
        'js/EditorUi.js',
        'js/Editor.js',
        'js/Sidebar.js',
        'js/Graph.js',
        'js/Format.js',
        'js/Shapes.js',
        'js/Actions.js',
        'js/Menus.js',
        'js/Toolbar.js',
        'js/Dialogs.js',
    ], {sourcemaps: false})
        .pipe(concat('all.min.js'))
        .pipe(uglify())
        .pipe(dest('./', {sourcemaps: false}))
}

exports.default = series(editor, pre, all)
