@extends('modstart::layout.frame')

@section('pageFavIco',\ModStart\Core\Assets\AssetsUtil::fix(modstart_config('siteFavIco')))
@section('pageTitle')@yield('pageTitleMain','') - {{modstart_config('siteName')}}@endsection
@section('pageKeywords',modstart_config('siteKeywords'))
@section('pageDescription',modstart_config('pageDescription'))

@section('headAppend')
    @parent
    <link rel="stylesheet" href="{{\ModStart\Core\Assets\AssetsUtil::fix('theme/'.modstart_config('siteTemplate','default').'/pc/css/style.css')}}"/>
    {!! modstart_config('systemCounter') !!}
@endsection

@section('bodyAppend')
    @parent
    {!! modstart_config('systemCounterBody') !!}
@endsection

@section('body')

    <header class="ub-header-b">
        <div class="ub-container">
            <div class="menu">
                @if(\Module\Member\Auth\MemberUser::id())
                    <a href="/member"><i class="iconfont icon-user"></i> {{\Module\Member\Auth\MemberUser::get('username')}}</a>
                    <a href="javascript:;" data-confirm="确认退出？" data-href="/logout">退出</a>
                @else
                    <a href="/login">登录</a>
                    <a href="/register">注册</a>
                @endif
            </div>
            <div class="logo">
                <a href="/">
                    <img src="{{\ModStart\Core\Assets\AssetsUtil::fix(modstart_config('siteLogo'))}}"/>
                </a>
            </div>
            <div class="nav-mask" onclick="$(this).closest('.ub-header-b').removeClass('show')"></div>
            <div class="nav">
                @foreach(\Module\Nav\Util\NavUtil::listByPositionWithCache('header') as $nav)
                    <a class="{{modstart_baseurl_active($nav['link'])}}" href="{{$nav['link']}}">{{$nav['name']}}</a>
                @endforeach
            </div>
            <a class="nav-toggle" href="javascript:;" onclick="$(this).closest('.ub-header-b').toggleClass('show')">
                <i class="show iconfont icon-list"></i>
                <i class="close iconfont icon-close"></i>
            </a>
        </div>
    </header>

    @section('bodyContent')
    @show

    <footer class="ub-footer">
        <div class="ub-container">
            <div class="line"></div>
            <div class="nav">
                @foreach(\Module\Article\Util\ArticleUtil::listByPositionWithCache('footer') as $footerArticle)
                    <a href="/article/{{$footerArticle['id']}}">{{$footerArticle['title']}}</a>
                @endforeach
            </div>
            <div class="copyright">
                <a href="http://beian.miit.gov.cn" target="_blank">{{modstart_config('siteBeian','[网站备案信息]')}}</a>
                &copy;{{modstart_config('siteDomain')}}
            </div>
        </div>
    </footer>
@endsection
