@extends($_viewFrame)

@section('pageTitle',modstart_config('siteName').' - '.modstart_config('siteSlogan'))
@section('headAppend')
    @parent
    <link rel="stylesheet" href="//at.alicdn.com/t/font_2493283_ome1go9256h.css" />
@endsection
@section('bodyContent')

    <div style="background:#FFF;">
        <div class="ub-container">
            @include('module::Banner.View.pc.public.banner',['position'=>'home','bannerRatio'=>'5-2'])
        </div>
    </div>

    <div style="background:#FFF;padding:2rem 0;">
        <div class="ub-container">
            <div class="ub-content">
                <div class="head">
                    <div class="title">系统特性</div>
                    <div class="sub-title">丰富的特性让您更好的管理文档</div>
                </div>
                <div class="body">
                    <div class="row">
                        <div class="col-md-3 col-6">
                            <div class="item-a">
                                <i class="icon soft-image-font soft-image-markdown-fill ub-color-a"></i>
                                <div class="title">
                                    Markdown文档
                                </div>
                                <div class="slogan">
                                    支持在线Markdown文档管理
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-6">
                            <div class="item-a">
                                <i class="icon soft-image-font soft-image-mind_map ub-color-b"></i>
                                <div class="title">
                                    在线脑图
                                </div>
                                <div class="slogan">
                                    支持在线脑图管理
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-6">
                            <div class="item-a">
                                <i class="icon soft-image-font soft-image-Graph ub-color-c"></i>
                                <div class="title">
                                    图表绘制
                                </div>
                                <div class="slogan">
                                    方便在线绘制图表
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-6">
                            <div class="item-a">
                                <i class="icon soft-image-font soft-image-editor ub-color-d"></i>
                                <div class="title">
                                    富文本内容
                                </div>
                                <div class="slogan">
                                    支持所见即所得文档管理
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-6">
                            <div class="item-a">
                                <i class="icon soft-image-font soft-image-Graph ub-color-e"></i>
                                <div class="title">
                                    多颜色标签
                                </div>
                                <div class="slogan">
                                    多种标签可设定颜色，文档整理更简洁
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-6">
                            <div class="item-a">
                                <i class="icon soft-image-font soft-image-share ub-color-a"></i>
                                <div class="title">
                                    灵活的访问方式
                                </div>
                                <div class="slogan">
                                    私有、公开、密码访问三种访问权限
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-6">
                            <div class="item-a">
                                <i class="icon soft-image-font soft-image-history ub-color-b"></i>
                                <div class="title">
                                    历史修订版本
                                </div>
                                <div class="slogan">
                                    保存历史修订版本，方便内容回溯
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-6">
                            <div class="item-a">
                                <i class="icon soft-image-font soft-image-clouddownload-fill ub-color-c"></i>
                                <div class="title">
                                    内容导出
                                </div>
                                <div class="slogan">
                                    支持SVG、PNG、HTML、MD文档导出
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div style="background:#FFF;">
        <div class="ub-container" style="max-width:1000px;margin:0 auto;">
            <div class="ub-content">
                <div class="head">
                    <div class="title">ALL IN ONE</div>
                    <div class="sub-title">多种文档组合处理，让您集中管理您的文档</div>
                </div>
                <div class="body">
                    <div class="item-e">
                        <div class="image">
                            <div class="cover contain ub-cover-3-2" style="background-image:url(@asset('theme/default/pc/image/image-1.png'));"></div>
                        </div>
                        <div class="text">
                            <div class="title">
                                Markdown文档管理
                            </div>
                            <div class="sub-title">
                                轻量级标记语言，易读易写
                            </div>
                            <div class="desc">
                                <p>· 支持标准Markdown语言书写</p>
                                <p>· 支持PC、手机效果预览</p>
                                <p>· 支持Markdown格式MD文件导出</p>
                                <p>· 支持HTML格式直接导出</p>
                            </div>
                        </div>
                    </div>
                    <div class="item-e">
                        <div class="image">
                            <div class="cover contain ub-cover-3-2" style="background-image:url(@asset('theme/default/pc/image/image-2.png'));"></div>
                        </div>
                        <div class="text">
                            <div class="title">
                                脑图文档管理
                            </div>
                            <div class="sub-title">
                                让您在线上直接创建、保存并分享你的思路
                            </div>
                            <div class="desc">
                                <p>· 基于SVG技术实现</p>
                                <p>· 支持多种优先级、主题编辑</p>
                                <p>· 支持SVG格式图片导出</p>
                                <p>· 支持PNG格式图片导出</p>
                            </div>
                        </div>
                    </div>
                    <div class="item-e">
                        <div class="image">
                            <div class="cover contain ub-cover-3-2" style="background-image:url(@asset('theme/default/pc/image/image-3.png'));"></div>
                        </div>
                        <div class="text">
                            <div class="title">
                                图表文档管理
                            </div>
                            <div class="sub-title">
                                基于web的流程图绘制工具
                            </div>
                            <div class="desc">
                                <p>· 适用在网页设计/编辑流程图</p>
                                <p>· 支持拖动和克隆细胞，重新调整和改造</p>
                                <p>· 支持多种布局方式</p>
                                <p>· 支持SVG、PNG格式文件导出</p>
                            </div>
                        </div>
                    </div>
                    <div class="item-e">
                        <div class="image">
                            <div class="cover contain ub-cover-3-2" style="background-image:url(@asset('theme/default/pc/image/image-4.png'));"></div>
                        </div>
                        <div class="text">
                            <div class="title">
                                富文本编辑器
                            </div>
                            <div class="sub-title">
                                轻量级的，基于浏览器的，所见即所得编辑器
                            </div>
                            <div class="desc">
                                <p>· 轻量、简洁、功能强大的在线编辑器</p>
                                <p>· 方便的快捷方式让您书写更流畅</p>
                                <p>· 简约的布局方式，让在线编辑器更美观</p>
                                <p>· 支持HTML格式直接导出</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection