import {HttpDao} from "../../vue-brick/lib/dao";

const config = {
    state: {
        id: 0,
        questions: [],
        questionMap: {},
        categorySelectListForParent: [],
        categoryTree: [],
        tags: [],
    },

    mutations: {
        SET_ROBOT_ID: (state, data) => {
            state.id = data
        },
        SET_ROBOT_QUESTIONS: (state, data) => {
            state.questions = data
            let map = {}
            data.forEach(o => {
                map[o.id] = o
            })
            state.questionMap = map
        },
        SET_ROBOT_CATEGORIES: (state, data) => {
            state.categorySelectListForParent = data[0]
            state.categoryTree = data[1]
        },
        SET_ROBOT_TAGS: (state, data) => {
            state.tags = data
        },
    },
    actions: {
        RefreshRobotId: ({commit}, data) => {
            commit('SET_ROBOT_ID', data)
        },
        RefreshRobotQuestions: ({commit}, data) => {
            HttpDao.exec('robot_knowledge_question/list_all', {robotId: data}, res => {
                commit('SET_ROBOT_QUESTIONS', res.data.records)
            })
        },
        RefreshRobotCategories: ({commit}, data) => {
            HttpDao.exec('robot_knowledge_category/all', {robotId: data}, res => {
                commit('SET_ROBOT_CATEGORIES', [res.data.selectListForParent, res.data.tree])
            })
        },
        RefreshRobotTags: ({commit}, data) => {
            HttpDao.exec('robot_knowledge_question_tag/list_all', {robotId: data}, res => {
                commit('SET_ROBOT_TAGS', res.data)
            })
        }
    }
}

export default config
