<?php
 /**
 +------------------------------------------------------------------------------
 * FramkPHP 快速易用PHP框架
 +------------------------------------------------------------------------------
 * @package  Framk
 * @author   shawn fon <ucic5@163.com>
 +------------------------------------------------------------------------------
 */
	class Action{
	
	private $view;


	/**
	* 构造函数：实例化视图类
	*/	
	public function __construct(){	
		$this->view= new View();
	}
 
	/**
	* 变量注入视图
	*
	* @param $key  变量引用名称
	* @param $value  变量值
	*
	* 使用示例：$this->assign('varName',$value);或	$this->assign(array('varName'=>$value));
	*/	
	public function assign($key,$value='') {	
		$this->view->_assign($key,$value);
	}	
	 
	/**
	* 加载视图
	*
	* @param $tpl  模板名称，留空则为当前操作的动作名称
	*
	* 使用示例：$this->show('test');或位于subdir文件夹下用$this->show('subdir/test');
	*/	 	 
	 public function show($tpl='') {
		$this->view->_show($tpl);
	 }

	/**
	* 返回数据缓存类对象
	*
	* 使用示例：$this->C()->findAll..
	*/ 
	public function C($cacheKey='') {
		return new Cache($cacheKey);
	} 
	/**
	*  过滤$_POST[]
	*
	* @param str 过滤键字符串
	* @param $commFilter  全局过滤方法
	*
	* 使用示例：$this->_post('id:isInt,title,content','_addslashes');	
	*/ 
	public function _post($str,$commFilter=''){

		$postArr = array();
		$arr=explode(',',str_replace(' ','',$str));
		if(is_readable(EXTEND.'Filter.class.php'))$Filter=_class('Filter');
		foreach ($arr as $v) {	
			$method='';
			$pos=strpos($v,':');
			if($pos>0){
			$fieldKey =substr($v,0,$pos);
			$method = substr($v,$pos+1,strlen($v));
			}else{
			$fieldKey = $v;
			}
			if(!isset($_POST[$fieldKey])) _error('POST_Error',$fieldKey);
			if (!empty($commFilter) && isset($Filter) && method_exists($Filter, $commFilter) ){
				$value=$Filter->$commFilter($_POST[$fieldKey]);
			}else{
				$value=$_POST[$fieldKey];
			}
			if(!empty($method) && isset($Filter) && method_exists($Filter, $method)){
				$result=$Filter->$method($value);
				if($result!=false){
					$postArr[$fieldKey]=$result;
				}else{
					 _error('POSTField_Error',$fieldKey);
				}
			}else{
				$postArr[$fieldKey]=$value;
			}
		}//
		return $postArr;
	}
	/**
	*  过滤传递参数
	*
	* @param str 过滤字符串 
	* @param $commFilter  全局过滤方法
	*
	* 使用示例：$this->_get('id:isInt,title,content','_addslashes');	
	*/ 
	public function _get($str,$commFilter=''){
		
		$getArr = array();
		$arr=explode(',',str_replace(' ','',$str));
		if(is_readable(EXTEND.'Filter.class.php'))$Filter=_class('Filter');
		foreach ($arr as $k=>$v) {	
			$method='';
			$pos=strpos($v,':');
			if($pos>0){
			$fieldKey =substr($v,0,$pos);
			$method = substr($v,$pos+1,strlen($v));
			}else{
			$fieldKey = $v;
			}
			if(isset($_GET['P'][$k+1])){
				if (!empty($commFilter) && isset($Filter) && method_exists($Filter, $commFilter) ){//全局过滤方法
					$value=$Filter->$commFilter($_GET['P'][$k+1]);
				}else{
					$value=$_GET['P'][$k+1];
				}
				if (!empty($method) && isset($Filter) && method_exists($Filter, $method) ){//单个参数过滤方法
					$value=$Filter->$method($value);
					if($value!=false){
						$getArr[$fieldKey]=$value;
					}else{
						 _error('GET_Error',$fieldKey);
					}
				}else{
					$getArr[$fieldKey]=$value;
				}
			}else{
				$getArr[$fieldKey]='';
			}
		}//
		return $getArr;
	}
	/**
	*  提示信息
	*
	* @param goUrl 转向路径 必填
	* @param $tipMsg  提示信息
	* @param $timeOut  跳转前停留在提示页面时间
	* @param $actPre  自定义转向前缀
	*
	* 使用示例：$this->go('back','添加失败',5);//表示：在提示页面显示提示信息：'添加失败' 停留5秒后返回上一步
	* 使用示例：$this->go('/Index','添加失败',5);//表示：在提示页面显示提示信息：'添加失败' 停留5秒后返回动作类'Index'
	* 使用示例：$this->go('','添加失败',5,'http://www.xxx.com/1.html');//表示：在提示页面显示提示信息：'添加失败' 停留5秒后转向
	  地址：http://www.xxx.com/1.html
	*/ 

	public function go($goUrl, $tipMsg='',$timeOut=0,$actPre='') {
		
		if($goUrl!=='back')$actPre==''? $goUrl=ACT.$goUrl: $goUrl=$actPre.$goUrl;
		$this->assign(array('goUrl'=>$goUrl,'tipMsg'=>$tipMsg,'timeOut'=>$timeOut));
		$this->show('tpl_default/go');
		exit();			
	}

 /*  +-------------------------------------------------------------------------- */
}//
?>