<?php
 /**
 +------------------------------------------------------------------------------
 * FramkPHP 快速易用PHP框架
 +------------------------------------------------------------------------------
 * @package  Framk
 * @author   shawn fon <ucic5@163.com>
 +------------------------------------------------------------------------------
 */
 
class DB {

private $db;

	/**
	* 初始化数据库	
	*/		 
	public function __construct(){	
		$dbConfig=$GLOBALS['C']['DB'];
		$this->db = _class($GLOBALS['C']['DB']['DBdriver'],$dbConfig);					 
	} 

	/**
	* 查询结果集并转换为二维数组，返回数组
	*
	* @param $sql  SQL查询语句
	*/	
	public	function findAll($sql){ 
	
		$data= array(); $row= array ();	$i=0;
		$result = $this->db->query($sql);	
		if(!$result) _error('queryError',$_GET['ACTION'].'.'.$_GET['METHOD'].'.findAll');	
		while ( ($row  = $this->db->fetch_array($result)) ) {	
		$data[$i++]=$row;				
		} 
		$this->db->free_result($result);	 
		return $data; 	 
	}	
	
	/**
	* 查询结果集数组（一维数组）返回数组
	*
	* @param $sql  SQL查询语句
	*/	
	public	function findOne($sql){
	
		$result = $this->db->query($sql);
		if(!$result) _error('queryError',$_GET['ACTION'].'.'.$_GET['METHOD'].'.findOne');
		$data=$this->db->fetch_array($result);	
		$this->db->free_result($result);	 
		return $data;
	}
	 
	/**
	* 计算数据记录条数，返回数据记录数
	*
	* @param $sql  SQL语句
	*/	
	public function countRecords($sql){	
	
		$result = $this->db->query($sql);
		if(!$result) _error('queryError',$_GET['ACTION'].'.'.$_GET['METHOD'].'.countRecords');
		$data=$this->db->fetch_array($result,MYSQL_NUM);	
		return $data[0];		
	}
	 
	/**
	* 更新数据，返回值：新增数据ID、影响的记录条数
	*
	* @param $sql  SQL更新语句
	*/		
	public function update($sql){

		$result=$this->db->query($sql);
		if(!$result){
			return -1;//更新失败返回-1
		}else{			
			$sql=trim($sql);
			$method=strtolower (substr($sql,0,6));
			if($method=='insert'||$method=='replace'){
			return  $this->db->insert_id();	
			}else{
			return $this->db->affected_rows();
			}		
		}	
	}

 /*  +------------------------------------------------------------------------------ */		

} //
?>