<?php
 /**
 +------------------------------------------------------------------------------
 * FramkPHP 快速易用PHP框架
 +------------------------------------------------------------------------------
 * @package  Framk
 * @author   shawn fon <ucic5@163.com>
 +------------------------------------------------------------------------------
 */
 
//定义框架目录常量
	header("content-Type: text/html; charset=utf-8 ");
	define ( 'FRAMK_VERSION', '1.7.131110' );
	define ( 'FRAMK', dirname(__FILE__).S);
	$appFolderName = array ('Action','Cache', 'Extend','View');
	foreach ( $appFolderName as $key=>$value ) {
		define ( strtoupper ( $value ), APP_ROOT.$value.S );
	}
	require_once (FRAMK . '_Function.php');//引入框架内置函数
	if (PHP_VERSION <5) _error('PHP_Version',PHP_VERSION);
		
//引入配置文件	

	$GLOBALS['C']= require_once(EXTEND .'Config.php');
	$GLOBALS['C']['Debug'] ? error_reporting ( E_ALL ) : error_reporting ( 0 );
	date_default_timezone_set ($GLOBALS['C']['TimeZone']);
	$GLOBALS['FramkClass']=array('Action','Cache','View' ,'DB','Mysql','Page');//已有的框架类	
	
//引入用户扩展函数与框架核心文件
	_import(FRAMK.'Action.class.php');	
	_import(FRAMK.'Cache.class.php');
	_import(FRAMK.'View.class.php');

	function RunFramk() {
	
//定义与项目名称相对路径APP、URL访问前缀ACT
		$scriptName=SCRIPT_NAME==='' ? $_SERVER ['SCRIPT_NAME'] : SCRIPT_NAME ;
		$app=str_replace ( '/'.basename($scriptName), '', $scriptName );//项目相对路径，如/demo 	
		$act=$GLOBALS['C']['ReWrite'] ? $app : $scriptName;	
		define ( 'APP', 'http://'.$_SERVER["HTTP_HOST"].$app );
		define ( 'ACT', 'http://'.$_SERVER["HTTP_HOST"].$act);

// 访问地址解析
		$urlStr=( $_SERVER ['REQUEST_URI'] == $app.'/')? '': str_replace ($act, '',  $_SERVER ['REQUEST_URI'] );
		if(!empty($_SERVER['QUERY_STRING'])){
			$queryArr=explode('&',$_SERVER['QUERY_STRING']);
			$queryStr='';
			foreach($queryArr as $v){
				$queryStr .=preg_replace('/(.*)\=/','/',$v);
			}
			$urlStr=str_replace('?'.$_SERVER['QUERY_STRING'],'',$urlStr).$queryStr;
		}
		$_urlArr=explode('/',urldecode($urlStr));//此时解编码，防止在上一步解析时将“网址”作为参数的访问地址也作解析
		$urlArr=array();
		foreach($_urlArr as $k=>$v){//过滤掉因多加如//引起的空参数,不用array_filter函数会把0过滤掉
			if($v!='') $urlArr[]=$v;
		}
		//print_r($urlArr);
		$ext=end($urlArr);//最后一个元素
		$pos=strpos($ext,$GLOBALS['C']['HtmlExt']);
		if($pos){//如果存在静态后缀		
			$num=str_replace(substr($ext,$pos),'',$ext);//取得实际参数值
			if(strpos($num,$GLOBALS['C']['PageFlag'])===0){//如果发现分页访问标识在第0位置，说明这是分页访问，如标识是下划线的分页后缀将只取'2' _2.html
			$_GET['CPAGE']=str_replace($GLOBALS['C']['PageFlag'],'',$num);
			array_pop($urlArr);//去掉分页的参数，若要取得分页数字通过$_GET['CPAGE']获取
			}else{
			array_splice($urlArr, -1, 1, str_replace($GLOBALS['C']['HtmlExt'], '', $ext));//否则将数组最后一个元素的静态后缀去掉，得到实际的参数数组
			}
		}	
		$actionDir='';	
		foreach($urlArr as $key=>$value){//获取Action目录				
			if(strcmp($value ,ucfirst($value))>0){//第一个字母小写被认为是目录名
				$actionDir .=$value.'/' ;	
				unset($urlArr[$key]);
			}else{
				break;
			}			
		}	
		$urlArr=array_merge($urlArr,array());	//重新排序
		
//取得动作方法并剔除动作方法从而得到参数
		if(!empty( $urlArr[0] )){
			$action=$urlArr[0];
			array_shift($urlArr);//剔除动作
		}else{
			$action=$GLOBALS['C']['Action'];
		}

		if(!empty( $urlArr[0] )){
			$method = $urlArr[0];
			array_shift($urlArr);//剔除方法
		}else{
			$method = $GLOBALS['C']['Method'];
		}
		$dir_action_method = empty( $actionDir) ? array($action,$method) :array($actionDir,$action,$method);
		$params=array_merge(array(''),$urlArr);//使参数取值时以键为1开始便于理解，如$p[1],取第一个参数的值
		$_GET['P']=$params;  $_GET['URL_']= implode('/',$params);//参数数组与参数字符串	
		$_GET['URL_ARR'] = array_merge($dir_action_method,$urlArr);//包括访问动作与方法的路径数组
		$_GET['URL']=ACT.'/'.implode('/',$_GET['URL_ARR']); //完整的访问路径字符串
		$_GET['ACTION'] = $action ; $_GET['METHOD'] = $method ;

		$ActObj = _class(ACTION.$actionDir.$action);
		if (method_exists ($ActObj, $method )) {	
			$ActObj->$method();
		} else {
			_error('methodNotExist', $action.'—>'.$method);
		}	
	}			
	
 /*  +------------------------------------------------------------------------------ */
?>