<?php	
	/**
	* 加载文件,可自动搜索加载Extend与Action下的文件
	*
	* @param $file  加载的文件名称
	* @param $autoSearch  是否要进行自动搜索
	*
	* 使用示例：_import(FRAMK.'Action.class.php');或	_import('Index.class.php',true);	或 _import('subDir/Index.class.php',true);
	前一种为完整路径不需要进行自动搜索，后两种需要在EXTEND 和 ACTION目录下进行自动搜索		
	*/	
	function _import($file,$autoSearch=false) {

		static $isLoad=array();	
		$importFile =str_replace ( '/', S, $file );	
		if(isset($isLoad[md5($importFile)])) return true;//避免重复加载
		if( is_readable($importFile) ){		
			require($importFile);
			$isLoad[md5($importFile)]=true;//加载文件后，添加已加载标记
			return true;
		}elseif($autoSearch===true){//进行自动搜索			
			$autoFilePath=array(EXTEND,ACTION);
			foreach($autoFilePath as $autoPath){
				$autoImportFile=$autoPath.$file;
				if(isset($isLoad[md5($autoImportFile)])) return true;
				if( is_readable($autoImportFile) ){
					require($autoImportFile);
					$isLoad[md5($autoImportFile)]=true;
					return true;
				}
			}//foreach	
		}else{
		_error ( 'fileNotExist', $importFile);
		}//else
	}
 
	/**
	* 加载并实例化类; 返回值：类对象 
	*
	* @param $classFile  加载的文件名称
	* @param $args  实例化时传入的参数，以数组形式传入
	* @param $autoSearch  是否要进行自动搜索，默认为真，如果用户加载的文件是完整路径，_import将不再进行下一步搜索
	*
	* 使用示例： _class('Page',array($totalNum, $this->pageSize, '/Index/main/page/'));	
			   _class('Html'); 	
	*/
	function _class($classFile, $args ='',$autoSearch=true) {
		
		$className = basename($classFile);//取得类名
		static $isNew=array();
		if(in_array($className,$GLOBALS['FramkClass'])){//加载位于框架下的类文件
			_import(FRAMK.$classFile.'.class.php');
		}else{
			_import($classFile.'.class.php',$autoSearch);//加载其它类文件
		}	

		if(isset($isNew[$className])){//判断是否已存在该实例，避免重复实例化同一个类
			return $isNew[$className];
		}else{
			if(class_exists($className)){
			$isNew[$className] = new $className($args);//实例化类，并添加已实例化的标记
			return $isNew[$className];		
			}else{
			_error ( 'classError', $classFile.'.class.php');
			}
		}	
	}
  
	/**
	* 建立多级目录; 返回值：目录
	*
	* @param $dir  目录路径
	* @param $mode  权限
	*
	* 使用示例： _buildDir ( CACHE.'Data/');
	*/
	function _buildDir($dir) {
		
		$pre='';$dirArr=array();
		if(substr($dir,0,1)=='/'||substr($dir,0,1)=='\\')$pre=S;
		if(strlen($dir)>strlen(str_replace(APP_ROOT,'',$dir)))$pre .=APP_ROOT;
		$_dirArr=explode(S,str_replace(array(APP_ROOT,'/'),array('',S),$dir));
		foreach($_dirArr as $k=>$v){//不用array_filter函数会把0过滤掉
			if($v!='') $dirArr[]=$v;
		}
		return $pre.buildDir_(implode(S,$dirArr)).S;
	}
	function buildDir_($dir, $mode = 0777) {
				
		if (is_dir ( $dir )) {// 如果存在则返回目录，否则循环建立多级目录再返回目录
			return  $dir;
		} else {
			buildDir_(dirname($dir), $mode);
			if(!mkdir($dir, $mode)) _error ( 'buildDirError', $dir);
			return  $dir;
		}	
	}
	/**
	* 是否为AJAX链接或提交方式
	*/	
   function _isAjax() {

		if(!empty($_POST['AJAX_SUBMIT']) || !empty($_GET['AJAX_SUBMIT']) || (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && 'xmlhttprequest' == strtolower($_SERVER['HTTP_X_REQUESTED_WITH']))){
		return true;
		}else{
		return false;
		}
	}
	/**
	* 错误提示; 输出错误信息
	*
	* @param $errorKey  错误索引键
	* @param $detail  错误的详细信息
	*
	* 使用示例：_error('methodNotExist','Database->'.$method);
	*/	

	function _error($errorKey, $detail = '') {

		if ($GLOBALS['C']['Debug']) {	
			static $errorArray=array();	
			$errorArray = require_once('_Error.php');
			if(array_key_exists($errorKey,$errorArray)){	 												
				$tipMsg=$errorArray[$errorKey];									
			}else{
				$tipMsg='访问出错，但该错误键没有定义';				
			}			
		}else{
			$tipMsg='页面访问出错'; 	
			$detail='';
			header('HTTP/1.1 404 Not Found');
			header("status: 404 Not Found");		
		}	
		$htmlStr='<center><div style="font-size:14px;line-height:30px;border-top:solid 1px #ccc;background-color:#eee">'.$tipMsg.$detail.'</div></center>';
		exit($htmlStr);		
	}	
 /*  +------------------------------------------------------------------------------ */
?>