<?php defined('SYSPATH') or die('No direct script access.');
/**
 * Difeye 引导加载程序, 用来加载difeye的启动类库
 * ----------------------------------------------------------------------------
 * The booter.php file
 * ============================================================================
 * @package		Difeye
 * @author		Difeye Team  mathcn  
 * @copyright	(c) 2010-2011 Difeye Team
 * @license		http://www.difeye.com/license
 * ============================================================================
 */
 

/**
 * 设置默认时区，东八区"Etc/GMT-8"
 * Set the default time zone.
 */
date_default_timezone_set("Asia/Shanghai");

/**
 * 设置默认地区
 * Set the default locale.
 * @see  http://php.net/setlocale
 */
setlocale(LC_ALL, 'zh_CN.utf-8');

/** 
 * 自动加载
 * Enable the Difeye auto-loader.
 * @see  http://php.net/spl_autoload_register
 */
spl_autoload_register(array('Difeye', 'auto_load'));


/**
 * Enable the Difeye auto-loader for unserialization.
 *
 * @see  http://php.net/spl_autoload_call
 * @see  http://php.net/manual/var.configuration.php#unserialize-callback-func
 */
ini_set('unserialize_callback_func', 'spl_autoload_call');

 

/**  
 * Initialize Difeye, setting the default options.
 *
 * The following options are available:
 *
 * - string   base_url    path, and optionally domain, of your application   NULL
 * - string   index_file  name of your index file, usually "index.php"       index.php
 * - string   charset     internal character set used for input and output   utf-8
 * - string   cache_dir   set the internal cache directory                   APPPATH/cache
 * - boolean  errors      enable or disable error handling                   TRUE
 * - boolean  profile     enable or disable internal profiling               TRUE
 * - boolean  caching     enable or disable internal caching                 FALSE
 */ 
Difeye::init(array(
	'base_url'   => '/', 
	'errors'	 => TRUE,
));

/**
 * Attach a file reader to config. Multiple readers are supported.
 */
Difeye::$config->attach(new Difeye_Config_File);


/**
 * 启用第三方模块
 * Enable modules. Modules are referenced by a relative or absolute path.
 */
Difeye::modules(array(
	'database'   	=> MODPATH.'database',   // Database access
	'mangodb'   	=> MODPATH.'mangodb',   // mangodb  Database access
	'smarty'		=> MODPATH.'smarty',     // smarty template engine
	'thrift'		=> MODPATH.'thrift',     // thrift engine
	'gearman'		=> MODPATH.'gearman',     // gearman client
	));


/**
 * Set the routes. Each route must have a minimum of a name, a URI and a set of
 * defaults for the URI.
 */
Route::set('default', '(<controller>(/<action>(/<id>)))')
	->defaults(array(
		'controller' => 'index',
		'action'     => '',
	));
	
/**
 * 404 Not Found
 */	
Route::set('catch_all', '<path>', array('path' => '.+'))
	->defaults(array(
	  'controller' => 'errors',
	  'action' => ''
));


// Load the base, low-level application functions
require APPPATH.'base'.EXT;


if ( ! defined('SUPPRESS_REQUEST'))
{
	/**
	 * Execute the main request. A source of the URI can be passed, eg: $_SERVER['PATH_INFO'].
	 * If no source is specified, the URI will be automatically detected.
	 */
	echo Request::instance()
		->execute()
		->send_headers()
		->response;
}





