<?php
/**
 * Difeye 用来链接数据库操作
 * ----------------------------------------------------------------------------
 * The sysuser.php file
 * ============================================================================
 * @package		Difeye
 * @author		Difeye Team  mathcn  cq
 * @copyright	(c) 2010-2013 Difeye Team
 * @license		http://www.difeye.com/license
 * ============================================================================
 */ 
	
	class model_sysadmin  extends model_db
	{
		/**
		 * 获取区域信息
			*
		 * @param string Null
		 * @return array
		 */
		public function getRegion($region_id)
		{
			$strQuery = 'SELECT area_id,areaname FROM '.$this->sysDB('area').' WHERE parentid='.$region_id.' ORDER BY area_id ASC';
			return $this->db->query(Database::SELECT,$strQuery  ,FALSE)->as_array();
			
			
		}
		/**
		 * 获取左侧导航分类
			*
		 * @param string Null
		 * @return array
		 */
		public function getNav_index($parent_id,$isLevel)
		{
			$strQuery = 'SELECT * FROM '.
			$this->sysDB('tree'). '  nav '.
			" WHERE nav.isDel =0 and parent_id =$parent_id order by isSort asc"  ;
			
			return $this->db->query(Database::SELECT,$strQuery  ,false)->as_array(); 
			
		}
		/**
		 * 按角色获取左侧导航分类
			*
		 * @param string Null
		 * @return array
		 */
		public function getNav_staff_index($parent_id,$isLevel,$auid)
		{
			$strQuery = 'SELECT * FROM '.$this->sysDB('permissions').'  p inner join '.$this->sysDB('tree')." t on p.tree_id = t.tree_id where au_id='$auid' and parent_id =$parent_id and isLevel =$isLevel ";
			
			
			
			return $this->db->query(Database::SELECT,$strQuery  ,false)->as_array(); 
			
		}
		
		/**
		 * 根据tree_id 获取第一级子节点
			*
		 * @param string Null
		 * @return array
		 */
		public function getfirstChild($tree_id)
		{
			$strQuery = 'select * from '.$this->sysDB('tree')." where parent_id = $tree_id order by isSort desc ";
			
			return $this->db->query(Database::SELECT,$strQuery,FALSE)->as_array();
			
		}	
		
		
		
		/**
		 * 删除权限清单 
			*
		 * @param string Null
		 * @return array
		 */
		public function del_permission($auid)
		{
			$strQuery = 'DELETE  FROM '.$this->sysDB('permissions')."  where au_id=$auid ";
			
			
			return $this->db->query(Database::DELETE,$strQuery ,FALSE) ;
			
		}			
		
		/**
		 * 增加权限清单 
			*
		 * @param string Null
		 * @return array
		 */
		public function add_permission($auid,$treeid,$time)
		{
			$strQuery = 'insert into '.$this->sysDB('permissions')." set au_id=$auid, tree_id =$treeid, inDate=$time ";
			
			return $this->db->query(Database::INSERT,$strQuery,TRUE);  
			
		}	
		
		
		/**
		 * 获取权限模块的父权限id； 
			*
		 * @param string Null
		 * @return array
		 */
		public function getparentID($tree_id)
		{
			$strQuery = 'select tree_id, parent_id from '.$this->sysDB('tree')." where tree_id = $tree_id  ";
			
			return $this->db->query(Database::SELECT,$strQuery,FALSE)->as_array();
			
		}	
		/**
		 * 获取权限模块的父权限id
			*
		 * @param string Null
		 * @return array
		 */
		public function getParts()
		{
			$strQuery = 'select * from '.$this->sysDB('tree')." where isLevel = 1 and isDel=0 ";
			
			return $this->db->query(Database::SELECT,$strQuery,FALSE)->as_array();
			
		}	
		/**
		 * 根据ID获取节点
			*
		 * @param string Null
		 * @return array
		 */
		public function getPartById($pid)
		{
			$strQuery = 'select * from '.$this->sysDB('tree')." where tree_id = $pid limit 1";
			
			return $this->db->query(Database::SELECT,$strQuery,FALSE)->current();
			
		}
		/**
		 * 添加菜单到栏目
			*
		 * @param string Null
		 * @return array
		 */
		public function addMenuToPart($p_id,$name,$url,$sort)
		{
			$level = $p_id==0?1:2;
			$strQuery = 'insert into '.$this->sysDB('tree')." (parent_id,cnRemark,fileUrl,isSort,isLevel,isDel,inDate,modDate) values('$p_id','$name','$url','$sort',$level,0,".time().",".time().")";
			
			return $this->db->query(Database::INSERT,$strQuery,FALSE);
			
		}	
		/**
		 * 修改栏目
			*
		 * @param string Null
		 * @return array
		 */
		public function updatePart($pid,$name,$url,$sort)
		{
			$strQuery = 'update '.$this->sysDB('tree')." set cnRemark='$name',fileUrl='$url',isSort='$sort',modDate='".time()."' where tree_id='$pid'";
			
			return $this->db->query(Database::UPDATE,$strQuery,FALSE);
			
		}
		/**
		 * 删除栏目
			*
		 * @param string Null
		 * @return array
		 */
		public function delPart($pid)
		{
			$pid = intval($pid);
			$tQuery = "select * from ".$this->sysDB('tree')." where parent_id=$pid";
			$tResult = $this->db->query(Database::SELECT,$tQuery,FALSE)->as_array();
			if(!empty($tResult)){
				return false;
			}else{
				$strQuery = 'delete from '.$this->sysDB('tree')." where tree_id='$pid'";
				return $this->db->query(Database::INSERT,$strQuery,FALSE);
			}
			
		}	
		/**
		 * 判断该权限是否在permissions存在,
			*
		 * @param string Null
		 * @return array
		 */
		public function isexitPermission($au_id,$tree_id)
		{
			$strQuery = 'select p_id from '.$this->sysDB('permissions')." where au_id = $au_id and tree_id = $tree_id ";
			
			return $this->db->query(Database::SELECT,$strQuery,FALSE)->as_array();
			
		}
		/**
		 * 获取左侧导航分类  
			*
		 * @param string Null
		 * @return array
		 */
		public function getNav_staff($auid)
		{
			$strQuery = 'SELECT * FROM '.$this->sysDB('permissions').'  p inner join '.$this->sysDB('tree')." t on p.tree_id = t.tree_id where au_id='$auid' ";
			
			
			return $this->db->query(Database::SELECT,$strQuery  ,TRUE)->as_array(); 
			
		}
		
		/**
		 * 获取左侧导航分类 
			*
		 * @param string Null
		 * @return array
		 */
		public function getNav()
		{
			$strQuery = 'SELECT * FROM '.
			$this->sysDB('tree'). '  nav '.
			' WHERE nav.isDel =0 ' ;
			
			return $this->db->query(Database::SELECT,$strQuery  ,TRUE)->as_array(); 
			
		}
		
		/**
		 * 验证是否为管理员
		 * @param string 
		 * @return bool
		 */
		public function checkadmin($username)
		{
			$strQuery = 'SELECT * FROM '.
						$this->sysDB('adminuser'). '  admin '.
						" WHERE admin.account ='$username' " ;
			return $this->db->query(Database::SELECT,$strQuery  ,FALSE)->current();
			 
		}


		/**
		 * 更新管理员登录时间和IP
		 *
		 * @param string Null
		 * @return array
		 */
		public function updatelogin($sid,$curtime,$au_lastIp)
		{
			$strQuery = 'update '.$this->sysDB('adminuser')." set loginDate=$curtime,lastIP='$au_lastIp'  where sid=$sid ";
			return $this->db->query(Database::UPDATE,$strQuery,FALSE) ;
			 
		}	
		
		/**
		 * 获取管理员列表
		 *
		 * @param string Null
		 * @return array
		 */
		public function getadmins($a_areaId)
		{
			$strQuery = 'SELECT * FROM '.$this->sysDB('adminuser') . ' WHERE level=1 OR level=2' ;
			return $this->db->query(Database::SELECT,$strQuery  ,TRUE)->as_array(); 
			 
		}	
		/**
		 * 获取管理员信息
			*
		 * @param string Null
		 * @return array
		 */
		public function getadmin($admin_id)
		{
			$strQuery = "SELECT * FROM ".$this->sysDB('adminuser') . " WHERE sid='".$admin_id."'" ;
			return $this->db->query(Database::SELECT,$strQuery  ,TRUE)->as_array(); 
			
		}	
		
		/**
		 * 获取组别获取销售人员
		 *
		 * @param string Null
		 * @return array
		 */
		public function getSalersBygroup($group)
		{
			$strQuery = 'SELECT * FROM '.$this->sysDB('adminuser') . " WHERE sgroup='$group' " ;

			return $this->db->query(Database::SELECT,$strQuery  ,TRUE)->as_array(); 
			 
		}		


		/**
		 * 更新管理员状态
		 *
		 * @param string Null
		 * @return array
		 */
		public function updatestatus($sid,$isDel)
		{
			$strQuery = 'update '.$this->sysDB('adminuser')." set isDel=$isDel  where sid=$sid ";
			return $this->db->query(Database::UPDATE,$strQuery,FALSE) ;
			 
		}	
		

		/**
		 * 获取管理员信息
		 *
		 * @param string Null
		 * @return array
		 */
		public function getuserinfo($sid)
		{
			$strQuery = 'SELECT * FROM '.$this->sysDB('adminuser')."  where sid='$sid' ";
			return $this->db->query(Database::SELECT,$strQuery  ,TRUE)->as_array(); 
		}	



		/**
		 * 添加管理员/操作员信息
		 *
		 * @param string Null
		 * @return array
		 */
		public function adduser($au_account,$au_password,$au_name,$saltNo)
		{
			$strQuery = 'INSERT INTO '.$this->sysDB('adminuser')." (account,psword,name,saltNo,isDel) VALUES ".
				" ('$au_account','$au_password','$au_name','$saltNo',1) " ;

			return $this->db->query(Database::INSERT,$strQuery  ,FALSE) ; 
			
		}
		
		/**
		 * 更新管理员信息
			*
		 * @param string Null
		 * @return array
		 */
		public function updateadmin($au_id,$au_name,$saltNo='',$au_password='')
		{
			if($au_password!='')
				$strQuery = 'update '.$this->sysDB('adminuser')." set name='$au_name', psword='$au_password',saltNo='$saltNo' where sid='$au_id' ";
			else
				$strQuery = 'update '.$this->sysDB('adminuser')." set name='$au_name' where sid='$au_id' ";
			
			return $this->db->query(Database::UPDATE,$strQuery,FALSE) ;
			
		}
		
		/**
		 * 删除管理员/操作员信息
			*
		 * @param string Null
		 * @return array
		 */
		public function delete($sid)
		{
			$strQuery = "DELETE FROM ".$this->sysDB('adminuser')." WHERE  sid='$sid' " ;
			return $this->db->query(Database::DELETE,$strQuery  ,FALSE) ; 
			
		}




	}
?>