<?php
/**
 * Difeye 公共函数
 * ----------------------------------------------------------------------------
 * The functions.php language demo file, to show how it works.
 * ============================================================================
 * @package		Difeye
 * @author		Difeye Team  mathcn  cq
 * @copyright	(c) 2010-2013 Difeye Team
 * @license		http://www.difeye.com/license
 * ============================================================================
 */


/*
 * 初始化后台左边的菜单
 * @author  difeye
 * @access  public
 * @param  none
 * @return  none
 */
function initMenu(){
	
	//获取左侧导航列表清单
	$syssub = new model_sysadmin();
	$navarry ;
	//获取第一级
	$tmp=array();
	$auid = Session::instance("database")->get("sid");
	$res1 = $syssub->getNav_staff_index(0,1,$auid) ;

	foreach($res1 as $key=>$value)
	{
		$tmp[$key]['tree_id'] = $value['tree_id'];
		$tmp[$key]['cnRemark'] = $value['cnRemark'];
		//获取第二级
		$res2 = $syssub->getNav_staff_index($value['tree_id'] ,2,$auid) ;
		foreach($res2 as $v)
		{
			$current_link = base_name($_SERVER['REQUEST_URI']);
			
			if($current_link == base_name($v['fileUrl'])){
				$tmp[$key]['active'] = 'yes';
				$v['current'] = 'yes';
			}elseif($current_link=='permission' && $v['fileUrl']=='/admin/list'){
				$tmp[$key]['active'] = 'yes';
				$v['current'] = 'yes';
			}
			$tmp[$key][$value['tree_id']][] = $v;
		}

	}
	$navarry = $tmp;
	Difeye::$view->assign("breadcrumb", breadcrumb($current_link));
	Difeye::$view->assign("navarry", $navarry);
	unset($syssub);	

}

function breadcrumb($current_link){
	return '当前位置:管理员管理&gt;管理员帐号列表';
}

/*
 * 去掉url后面的参数
 * @author  cq
 * @access  public
 * @file  string of url
 * @return  string
 */
function base_name($file){
	$basename = basename($file);
	$arr = explode('?',$basename);
	return $arr[0];
}


/**
 * 检查登录权限和角色权限
 * @author  mathcn
 * @return  void
 */
function checkPermission()
{
	$intadUid = Session::instance("database")->get("sid");
	if(!$intadUid)
	{
		echo "<script language='javascript'>location='/'</script>";
	}
	
}


/**
 * 获得用户的真实IP地址
	*
 * @access  public
 * @return  string
 */
function real_ip()
{
    static $realip = NULL;
	
    if ($realip !== NULL)
    {
        return $realip;
    }
	
    if (isset($_SERVER))
    {
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
        {
            $arr = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
			
            /* 取X-Forwarded-For中第一个非unknown的有效IP字符串 */
            foreach ($arr AS $ip)
            {
                $ip = trim($ip);
				
                if ($ip != 'unknown')
                {
                    $realip = $ip;
					
                    break;
                }
            }
        }
        elseif (isset($_SERVER['HTTP_CLIENT_IP']))
        {
            $realip = $_SERVER['HTTP_CLIENT_IP'];
        }
        else
        {
            if (isset($_SERVER['REMOTE_ADDR']))
            {
                $realip = $_SERVER['REMOTE_ADDR'];
            }
            else
            {
                $realip = '0.0.0.0';
            }
        }
    }
    else
    {
        if (getenv('HTTP_X_FORWARDED_FOR'))
        {
            $realip = getenv('HTTP_X_FORWARDED_FOR');
        }
        elseif (getenv('HTTP_CLIENT_IP'))
        {
            $realip = getenv('HTTP_CLIENT_IP');
        }
        else
        {
            $realip = getenv('REMOTE_ADDR');
        }
    }
	
    preg_match("/[\d\.]{7,15}/", $realip, $onlineip);
    $realip = !empty($onlineip[0]) ? $onlineip[0] : '0.0.0.0';
	
    return $realip;
}

function isEmail($str){
    return (preg_match('/^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,4}$/',$str))?true:false;
}


/*
 * 获取权限清单
 */
function getPermissionList()
{
	//获取左侧导航列表清单
	$syssub = new model_sysadmin();
	$navarry ;
	//获取第一级
	$tmp=array();
	$res1 = $syssub->getNav_index(0,1) ;
	foreach($res1 as $key=>$value)
	{
		$tmp[$key]['tree_id'] = $value['tree_id'];
		$tmp[$key]['cnRemark'] = $value['cnRemark'];
		//获取第二级
		$res2 = $syssub->getNav_index($value['tree_id'] ,2) ;
		foreach($res2 as $k=>$v)
		{
			$tmp[$key][$value['tree_id']][] = $v;
		}
	}
	return $navarry = $tmp;
}


/*
 * 获取子节点
 * @author  difeye
 * @access  public
 * @tree_id  父节点ID
 * @return  array
 */
function get_child_tree($tree_id = 0)
{
	$syssub = new model_sysadmin();
	$res = $syssub->getfirstChild($tree_id) ;
	$thress_arr = array();
	
	foreach($res as $row)
	{
		if (!$row['isDel'])
		{
			$three_arr[$row['tree_id']]['cnRemark'] = $row['cnRemark'];
			$three_arr[$row['tree_id']]['fileUrl']  = $row['fileUrl'];            
			
			if( $syssub->getfirstChild( $row['tree_id'] ) )
			{
				$three_arr[$row['tree_id']]['tree_id'] = get_child_tree($row['tree_id']);
			}
		}
	}
    return $three_arr;
}


/*
 * 插入父节点记录
 * @author  jack
 * @access  public
 * @param  
	$str  字符串
 * @return  false or true
 */
function insertparentId($au_id,$tree_id )
{
	//获取tree_id的父节点parent_id，
	$obj = new model_sysadmin();
	$res = $obj->getparentID($tree_id);
	foreach($res as $rek=>$re)
	{
		$parent_id  = $re['parent_id'] ;
		
		
	}
	
	
	
	
	if($parent_id !=0 )
	{
		//判断下父节点 在 permission 表中是否存在，如果不存在则插入。
		$res = $obj->isexitPermission( $au_id ,$parent_id);
		if( !$res )
		{
			//添加到权限表
			$obj->add_permission($au_id,$parent_id,time());
		}
		//递归判断父节点是否已达到顶部
		insertparentId($au_id,$parent_id );
	}
}

/*
 * 验证字符串
 * @author  yx
 * @access  public
 * @param  
	$string  字符串
 * @return  $string
 */
function saddslashes($string) {
	if(is_array($string)) {
		foreach($string as $key =>$val) {
			$string[$key] = saddslashes($val);
		}
	} else {
		$string = addslashes($string);
	}
	
	return $string;
}
//过滤字符串
function mtrim($content){
	if (is_array($content)) {
		foreach ($content as $key=>$value) {
			$content[$key] = mtrim($value);
		}
	} else {
		if (!get_magic_quotes_gpc()){
			$content = stripslashes($content);
			$content = addslashes(trim($content));
		}
		else{
			$content = trim($content);
		}
	}
	return $content;
}
