<?php defined('SYSPATH') or die('No direct script access.');
/**
 * Database-based session class.
 *
 * Sample schema:
 *
 *     CREATE TABLE  `sessions` (
 *         `session_id` VARCHAR( 24 ) NOT NULL,
 *         `last_active` INT UNSIGNED NOT NULL,
 *         `contents` TEXT NOT NULL,
 *         PRIMARY KEY ( `session_id` ),
 *         INDEX ( `last_active` )
 *     ) ENGINE = MYISAM ;
 *
 * ============================================================================
 * @package		Difeye
 * @author		Difeye Team  mathcn  
 * @copyright	(c) 2010-2011 Difeye Team
 * @license		http://www.difeye.com/license
 * ============================================================================
 */
class Difeye_Session_Database extends Session {

	// Database instance
	protected $_db;
	
	// Table prefix
	protected $_pre = '';

	// Database table name
	protected $_table = 'sys_sessions';

	// Database column names
	protected $_columns = array(
		'session_id'  => 'session_id',
		'last_active' => 'last_active',
		'contents'    => 'contents'
	);

	// Garbage collection requests
	protected $_gc = 500;

	// The current session id
	protected $_session_id;

	// The old session id
	protected $_update_id;

	public function __construct(array $config = NULL, $id = NULL)
	{
		
		$_table = $_pre.$_table ; 
		
		if ( ! isset($config['group']))
		{
			// Use the default group
			$config['group'] = 'default';
		}

		// Load the database
		$this->_db = Database::instance($config['group']);

		if (isset($config['table']))
		{
			// Set the table name
			$this->_table = (string) $config['table'];
		}

		if (isset($config['gc']))
		{
			// Set the gc chance
			$this->_gc = (int) $config['gc'];
		}

		if (isset($config['columns']))
		{
			// Overload column names
			$this->_columns = $config['columns'];
		}

		parent::__construct($config, $id);

		if (mt_rand(0, $this->_gc) === $this->_gc)
		{
			// Run garbage collection
			// This will average out to run once every X requests
			$this->_gc();
		}
	}

	public function id()
	{
		return $this->_session_id;
	}

	protected function _read($id = NULL)
	{
		if ($id OR $id = Cookie::get($this->_name))
		{
			
			$sSql= "select contents from ".$this->_table." where  session_id='".$id."' limit 1";
			
			$result = $this->_db->query(Database::SELECT,$sSql,TRUE) ;
			
			if ($result->count())
			{
				// Set the current session id
				$this->_session_id = $this->_update_id = $id;
				
				// Return the contents
				return $result->get('contents');
			}
		}

		// Create a new session id
		$this->_regenerate();

		return NULL;
	}

	protected function _regenerate()
	{
		// Create the query to find an ID
		do
		{
			// Create a new session id
			$id = str_replace('.', '-', uniqid(NULL, TRUE));

			// Get the the id from the database
			$sSql= "select session_id from ".$this->_table." where  session_id='".$id."' limit 1";
			$result = $this->_db->query(Database::SELECT,$sSql,TRUE);
			
			
		}
		while ($result->count());

		return $this->_session_id = $id;
	}

	protected function _write()
	{
		$new_id = $this->_session_id ;
		$old_id = $this->_update_id ;
		$active = $this->_data['last_active'] ;
		$contents = $this->__toString() ;

		
		if ($this->_update_id === NULL)
		{
			// Insert a new row
			$sSql= "insert into ".$this->_table." (".implode( ',',$this->_columns).") values ( '$new_id',$active,'$contents' ) ";
			
			$query = $this->_db->query(Database::INSERT,$sSql,FALSE);
				
				
		}
		else
		{
			// Update the row
			$sSql = "update ".$this->_table." set last_active = ".$this->_data['last_active'].",contents =' ".$this->__toString()."' where session_id = '".$this->_update_id."'" ;
			
				
			if ($this->_update_id !== $this->_session_id)
			{
				// Also update the session id
				$sSql = "update ".$this->_table." set last_active = ".$this->_data['last_active'].",contents = '".$this->__toString()."', session_id ='". $this->_session_id."'  where session_id = '".$this->_update_id ."'";

			}
			
			$query = $this->_db->query(Database::UPDATE,$sSql,FALSE);
			
		}

		// The update and the session id are now the same
		$this->_update_id = $this->_session_id;

		// Update the cookie with the new session id
		Cookie::set($this->_name, $this->_session_id, $this->_lifetime);

		return TRUE;
	}

	protected function _destroy()
	{
		if ($this->_update_id === NULL)
		{
			// Session has not been created yet
			return TRUE;
		}

		$sSql= "delete from ".$this->_table." where session_id ='".$this->_update_id ."'";
		

		try
		{
			// Execute the query
			$query = $this->_db->query(Database::DELETE,$sSql,FALSE);
			
			// Delete the cookie
			Cookie::delete($this->_name);
		}
		catch (Exception $e)
		{
			// An error occurred, the session has not been deleted
			return FALSE;
		}

		return TRUE;
	}

	protected function _gc()
	{
		if ($this->_lifetime)
		{
			// Expire sessions when their lifetime is up
			$expires = $this->_lifetime;
		}
		else
		{
			// Expire sessions after one month
			$expires = 2629744;

		}
		
		$sSql= "delete from ".$this->_table." where last_active <". time() - $expires ;
		$query = $this->_db->query(Database::DELETE,$sSql,FALSE);
		

			
			
	}

} // End Session_Database
