<?php defined('SYSPATH') or die('No direct script access.');
/**
 * MongoDB-based session class.
 *
 ** sessions indexes **
 * db["sessions"].ensureIndex({
 * "_id": 1
 * },[
 * 
 *	]);
 *
 *	** sessions records **
 *	db["sessions"].insert({
 *	  "_id": ObjectId("4d99fb367f8b9a750c000001"),
 *	  "session_id": "4d99fb36352e23-91308614",
 *	  "last_active": 1301936950,
 *	  "contents": "YToyOntzOjExOiJzZXNzaW9ubmFtZSI7czoxMjoic2Vzc2lvbnZhbHVlIjtzOjExOiJsYXN0X2FjdGl2ZSI7aToxMzAxOTM2OTUwO30="
 *});
 *
 * ============================================================================
 * @package		Difeye
 * @author		Difeye Team  mathcn  
 * @copyright	(c) 2010-2011 Difeye Team
 * @license		http://www.difeye.com/license
 * ============================================================================
 */
class Difeye_Session_Mangodb extends Session {

	// Database instance
	protected $_db;
	// The current session id
	protected $_session_id;

	// The old session id
	protected $_update_id;

	//sessionݿ
	public $sessiondb = 'difeyeshop';
	//sessionڱ
	public $sessiontb = 'sessions';
	
	//ݿ⼯Ͼ
	protected function getdbtb()
	{
		//sessionݿ
		$sessiondb = 'difeyeshop';
		//sessionڱ
		$sessiontb = 'sessions';

		$collection = $this->_db->$sessiondb->$sessiontb ;
		
		return $collection;
	}



	public function __construct(array $config = NULL, $id = NULL)
	{
		//$this->_read('4d9ac233903d31-93334830') ;
		$this->_read();
		



		if (isset($config['gc']))
		{
			// Set the gc chance
			$this->_gc = (int) $config['gc'];
		}

	

		parent::__construct($config, $id);

		if (mt_rand(0, $this->_gc) === $this->_gc)
		{
			// Run garbage collection
			// This will average out to run once every X requests
			$this->_gc();
		}
		

	}

	public function id()
	{
		return $this->_session_id;
	}

	protected function _read($id = NULL)
	{
		
		if ($id OR $id = Cookie::get($this->_name))
		{
			
			$this->_db = Mangodb::instance(MangoDB::READ);

			$collection = $this->getdbtb();
			
			$query = array('session_id'=>$id);
			$res = $collection->findone($query )  ;
			
			if ($res)
			{
				// Set the current session id
				$this->_session_id = $this->_update_id = $id;
				
				// Return the contents
				return $res['contents'];
			}
		

		}
		
		// Create a new session id
		$this->_regenerate();

		return NULL;

	}

	protected function _regenerate()
	{
		// Create a new session id
		$id = str_replace('.', '-', uniqid(NULL, TRUE));
		

		return $this->_session_id = $id;
	}

	protected function _write()
	{
		$new_id = $this->_session_id ;
		$old_id = $this->_update_id ;
		$active = $this->_data['last_active'] ;
		$contents = $this->__toString() ;

		
		if ($this->_update_id === NULL)
		{
			// Insert a new row
			$obj = array( "session_id" => $new_id , "last_active" => $active,"contents" => $contents );
			$this->_db = Mangodb::instance(MangoDB::WRITE);
			$collection = $this->getdbtb();

			$collection->insert($obj); 
		}else{

			$this->_db = Mangodb::instance(MangoDB::WRITE);
			$collection = $this->getdbtb();
			
			$collection->update( array('session_id'=>$this->_update_id ), 
								array('$set'=> array( 'last_active'=>$this->_data['last_active']) ) 
							);

			if ($this->_update_id !== $this->_session_id)
			{
				// Also update the session id				
				$collection->update( array('session_id'=>$this->_update_id ), 
								array('$set'=> array( 'last_active'=>$this->_data['last_active'],'contents'=>$this->__toString(),'session_id'=>$this->_session_id ) ) 
							);


			}



		}
		
		 


		// Update the cookie with the new session id
		Cookie::set($this->_name, $this->_session_id, $this->_lifetime);

		return TRUE;
	
	}

	protected function _destroy()
	{
		if ($this->_update_id === NULL)
		{
			// Session has not been created yet
			return TRUE;
		}

		$this->_db = Mangodb::instance(MangoDB::WRITE);
		$collection = $this->getdbtb();
		
			

		try
		{
			// Execute the query
			$collection->remove( array('session_id' => $this->_update_id  )   );

			// Delete the cookie
			Cookie::delete($this->_name);
		}
		catch (Exception $e)
		{
			// An error occurred, the session has not been deleted
			return FALSE;
		}

		return TRUE;

	}

	protected function _gc()
	{

		if ($this->_lifetime)
		{
			// Expire sessions when their lifetime is up
			$expires = $this->_lifetime;
		}
		else
		{
			// Expire sessions after one month
			$expires = Date::MONTH;
		}
		

		$this->_db = Mangodb::instance(MangoDB::WRITE);
		$collection = $this->getdbtb();
		
		$collection->remove( array('last_active' => array($lt =>time()-$expires)  )   );

			
			
	}






} // End Session
