﻿<?php
/*************The thrift PHP Libs ****************/
require_once(MODPATH.'/thrift/classes/libs/Thrift.php');
require_once(MODPATH.'/thrift/classes/libs/transport/TSocket.php');
require_once(MODPATH.'/thrift/classes/libs/transport/TBufferedTransport.php');

require_once(MODPATH.'/thrift/classes/libs/transport/TMemoryBuffer.php');

require_once(MODPATH.'/thrift/classes/libs/protocol/TBinaryProtocol.php');

require_once(MODPATH.'/thrift/classes/libs/protocol/TCompactProtocol.php');
require_once(MODPATH.'/thrift/classes/libs/protocol/TBinarySerializer.php');

require_once(MODPATH.'/thrift/classes/libs/packages/hadoopfs/ThriftHadoopFileSystem.php');


class Difeye_Thrift {


	//存储config里的多个实例化
	public static $instances = array(); 
	public static $configs = array();


	public static function instance( $type='default' )
	{
		
		$configs = Difeye::config('thrift');

		
		if( Thrift::$instances[$type] == NULL)
		{
			$config = $configs[$type]  ;
			if(is_array($config))
			{
				Thrift::$instances[$type] = self::connection($config);

			}else{
				throw new Difeye_Exception($type.' does not exist, please check the difeye/modules/thrift/config/thrift.php server name list');

			}

			
		}
		

		if (Thrift::$instances[$type])
		{
			return Thrift::$instances[$type];
		}


		
		
	}



	/*
	 * create connection method
	 * use thrift interface to connect to hadoop hdfs 
	 * param: $configArr for example 
		'connection' => array(
			'hostnames' => '192.168.0.11',
			'port'  => '45905',
			'SendTimeout'  => '10000',
			'RecvTimeout'  => '20000',
		),
	 * return: if success return connection object, else return false
	 * Note: if the param is null, this method will try read from a config file
	 */
	public function connection($configArr = null)
	{
		// Extract the connection parameters
		extract($configArr['connection']);
		
		if (isset($hostnames) && isset($port) && isset($SendTimeout) && isset($RecvTimeout) )
		{ 
			
			$thrift_ip = trim($hostnames);
			$thrift_port = trim($port);
			$send_timeout = trim($SendTimeout);
			$recv_timeout = trim($RecvTimeout);

			

			$socket = new TSocket($thrift_ip, $thrift_port); // ThriftServer 的 IP 和端口
			$socket->setSendTimeout($send_timeout);
			$socket->setRecvTimeout($recv_timeout);


		}else{
			
			throw new Difeye_Exception('No  specified Params in Thrift Config');
		}


		if ($socket)
		{
			return $socket;
		}



	}







	/**
	 * 销毁数据库连接
	 */
	public function disconnect()
	{
		if (Thrift::$instances)
		{
			foreach( Thrift::$instances as $item )
			{
				$item->close()  ;
			}
		}

		Thrift::$instances = NULL;

	}
	
	//销毁类
	final public function __destruct()
	{
		Thrift::disconnect();
	}


}

?>