<?php defined('SYSPATH') or die('No direct access');
/**
 * Difeye exception class. Translates exceptions using the [I18n] class.
 *
 * ============================================================================
 * @package		Difeye
 * @author		Difeye Team  mathcn  
 * @copyright	(c) 2010-2011 Difeye Team
 * @license		http://www.difeye.com/license
 * ============================================================================
 */
class Difeye_Exception extends Exception {

	/**
	 * Creates a new translated exception.
	 *
	 *     throw new Difeye_Exception('Something went terrible wrong, :user',
	 *         array(':user' => $user));
	 *
	 * @param   string     error message
	 * @param   array      translation variables
	 * @param   integer    the exception code
	 * @return  void
	 */
	public function __construct($message, array $variables = NULL, $code = 0)
	{
		// ٵ__ʹI18෭Ϣ
		//$message = __($message, $variables);
		$message = empty($variables) ? $message : strtr($message, $variables);

		// Pass the message to the parent
		parent::__construct($message, $code);
	}

	/**
	 * Magic object-to-string method.
	 *
	 *     echo $exception;
	 *
	 * @uses    Difeye::exception_text
	 * @return  string
	 */
	public function __toString()
	{
		return Difeye::exception_text($this);
	}

} // End Difeye_Exception
