<?php
/**
 * 首页文件
 * ----------------------------------------------------------------------------
 * The index.php file
 * ============================================================================
 * @package		Difeye
 * @author		Difeye Team  mathcn  
 * @copyright	(c) 2010-2011 Difeye Team
 * @license		http://www.difeye.com/license
 * ============================================================================
 */


/**
 * 您的应用程序应该放在此文件夹内
 * The directory in which your application specific resources are located.
 */
$application = 'do';


/**
 * 您的自定义模块放在此文件夹内
 * The directory in which your modules are located.
 */
$modules = 'modules';

/**
 * Difeye的系统文件夹
 * The directory in which the Difeye resources are located.
 */
$system = 'system';

/**
 * 文件扩展名
 * The default extension of resource files. 
 */
define('EXT', '.php');
/**
 * 设定PHP报错级别
 * Set the PHP error reporting level. If you set this in php.ini, you remove this.
 * @see  http://php.net/error_reporting
 *
 * When developing your application, it is highly recommended to enable notices
 * and strict warnings. Enable them by using: E_ALL | E_STRICT
 *
 * In a production environment, it is safe to ignore notices and strict warnings.
 * Disable them by using: E_ALL ^ E_NOTICE
 *
 * When using a legacy application with PHP >= 5.3, it is recommended to disable
 * deprecated notices. Disable with: E_ALL & ~E_DEPRECATED
 */
error_reporting(E_ALL ^ E_NOTICE);

/**
 * 获取网站根目录绝对路径
 * Get the website wwwroot
 */
define('WWWROOT', realpath(dirname(__FILE__)).DIRECTORY_SEPARATOR);

/**
 * 根据网站根目录获取Difeye的绝对路径
 * Make the difeye directory relative to the wwwroot
 */
define('DIFEYE_PATH',WWWROOT.'difeye'.DIRECTORY_SEPARATOR);



// Define the absolute paths for configured directories
define('APPPATH', realpath(DIFEYE_PATH.$application).DIRECTORY_SEPARATOR);
define('MODPATH', realpath(DIFEYE_PATH.$modules).DIRECTORY_SEPARATOR);
define('SYSPATH', realpath(DIFEYE_PATH.$system).DIRECTORY_SEPARATOR);
// Clean up the configuration vars
unset($application, $modules, $system);



// Load the base, low-level system functions
require SYSPATH.'base'.EXT;

/**
 * 加载difeye_core核心类
 * Load the core Difeye_Core class
 */
require SYSPATH.'classes/difeye/core'.EXT;

	
/**
 * 加载difey空类，difey继承difey_core类
 * Load the Difeye class extend from difeye_core class
 */
require SYSPATH.'classes/difeye'.EXT;


// Boot the application
require APPPATH.'booter'.EXT;

