<?php

/**
 * Navigation - Check if we can find a menu id by using the alias.
 * @author Jason Schoeman, Contact: titan [at] phpdevshell [dot] org.
 *
 */
class NAVIGATION_findMenuQuery extends PHPDS_query
{
	protected $sql = "
		SELECT
			t1.menu_id
		FROM
			_db_core_menu_items t1
		WHERE
			t1.alias = '%s'
		OR
			t1.menu_id = '%s'
	";

	protected $singleValue = true;
}

/**
 * Navigation - Check if we can find an alias by menu id.
 * @author Jason Schoeman, Contact: titan [at] phpdevshell [dot] org.
 *
 */
class NAVIGATION_findAliasQuery extends PHPDS_query
{
	protected $sql = "
		SELECT
			t1.alias
		FROM
			_db_core_menu_items t1
		WHERE
			t1.menu_id = '%s'
	";

	protected $singleValue = true;
}

/**
 * Navigation - Extract all available menus user belings too.
 * @author Jason Schoeman, Contact: titan [at] phpdevshell [dot] org.
 *
 */
class NAVIGATION_extractMenuQuery extends PHPDS_query
{
	protected $sql = "
		SELECT DISTINCT SQL_CACHE
			t1.menu_id, t1.parent_menu_id, t1.menu_name, t1.menu_link, t1.plugin, t1.menu_type, t1.extend, t1.new_window, t1.rank, t1.hide, t1.template_id, t1.alias, t1.layout, t1.params,
			t3.is_parent, t3.type,
			t6.template_folder
		FROM
			_db_core_menu_items t1
		LEFT JOIN
			_db_core_user_role_permissions t2
		ON
			t1.menu_id = t2.menu_id
		LEFT JOIN
			_db_core_menu_structure t3
		ON
			t1.menu_id = t3.menu_id
		LEFT JOIN
			_db_core_templates t6
		ON
			t1.template_id = t6.template_id
		WHERE
			(t2.user_role_id IN (%s))
		ORDER BY
			t3.id
		ASC
	";

	/**
	 * Loads favorite control panel menu items.
	 * @param int $limit_favorite_db
	 * @return array
	 */
	public function invoke($parameters = null)
	{
		$all_user_roles = $parameters[0];
		if (empty($all_user_roles)) throw new PHPDS_Exception('Cannot extract menus when no roles are given.');
		$select_menus = parent::invoke($all_user_roles);

		$navigation = $this->navigation;
		$aburl = $this->configuration['absolute_url'];
		$sef = ! empty($this->configuration['sef_url']);
		$append = ! empty($this->configuration['url_append']);

		foreach ($select_menus as $mr) {
			////////////////////////
			// Create menu items. //
			////////////////////////
			$navigation->navigation[$mr['menu_id']]['menu_id'] = $mr['menu_id'];
			$navigation->navigation[$mr['menu_id']]['parent_menu_id'] = $mr['parent_menu_id'];
			$navigation->navigation[$mr['menu_id']]['alias'] = $mr['alias'];
			// Determine menu name.
			$navigation->navigation[$mr['menu_id']]['menu_name'] = $navigation->determineMenuName($mr['menu_name'], $mr['menu_link'], $mr['menu_id'], $mr['plugin']);
			$navigation->navigation[$mr['menu_id']]['menu_link'] = $mr['menu_link'];
			$navigation->navigation[$mr['menu_id']]['rank'] = $mr['rank'];
			$navigation->navigation[$mr['menu_id']]['hide'] = $mr['hide'];
			$navigation->navigation[$mr['menu_id']]['new_window'] = $mr['new_window'];
			$navigation->navigation[$mr['menu_id']]['is_parent'] = $mr['is_parent'];
			$navigation->navigation[$mr['menu_id']]['type'] = $mr['type'];
			$navigation->navigation[$mr['menu_id']]['template_folder'] = $mr['template_folder'];
			$navigation->navigation[$mr['menu_id']]['layout'] = $mr['layout'];
			if (! empty($mr['params']))
				$navigation->navigation[$mr['menu_id']]['params'] = html_entity_decode($mr['params']);
			else
				$navigation->navigation[$mr['menu_id']]['params'] = '';
			$navigation->navigation[$mr['menu_id']]['plugin'] = $mr['plugin'];
			$navigation->navigation[$mr['menu_id']]['menu_type'] = $mr['menu_type'];
			$navigation->navigation[$mr['menu_id']]['extend'] = $mr['extend'];
			$navigation->navigation[$mr['menu_id']]['plugin_folder'] = 'plugins/' . $mr['plugin'] . '/';
			// Check if we should can return the url as friendly.
			if ($sef && ! empty($mr['alias'])) {
				if ($mr['menu_type'] != 3) {
					$navigation->navAlias[$mr['alias']] = $mr['menu_id'];
				} else {
					$navigation->navAlias[$mr['alias']] = $mr['extend'];
				}
				if($append) {
					$navigation->navigation[$mr['menu_id']]['href'] = $aburl . '/' . $mr['alias'] . $this->configuration['url_append'];
				} else {
					$navigation->navigation[$mr['menu_id']]['href'] = $aburl . '/' . $mr['alias'];
				}
			} else {
				if ($mr['menu_type'] != 3) {
					$navigation->navigation[$mr['menu_id']]['href'] = $aburl . '/index.php?m=' . $mr['menu_id'];
				} else {
					$navigation->navigation[$mr['menu_id']]['href'] = $aburl . '/index.php?m=' . $mr['extend'];
				}
			}
			// Writing children for single level dropdown.
			if (! empty($mr['parent_menu_id'])) {
				$navigation->child[$mr['parent_menu_id']][] = $mr['menu_id'];
			}
		}
	}
}
