#!/bin/bash

# Pass the directory through that needs to be sync to, sync /some/directory
# Sync main trunk to other projects.
clear
echo ""
echo ""
echo " _     _  _        __            "
echo "|_)|_||_)| \ _    (_ |_  _  |  | "
echo "|  | ||  |_/(/_\_/__)| |(/_ |  | "
echo ""
echo "GNU/LGPL Copyright (C) 2012 Jason Schoeman"
echo ""
echo "This script will attempt to updated your other projects from this release to whatever directory you wish. This shell uses rsync."
echo ""

DIR=$1

if [$DIR -eq ""]; then
echo ""
echo "Error (1):"
echo ""
echo "No directory parameter passed through!"
echo "Pass the directory through that needs to be sync to eg. sync.sh /some/directory"
exit 0
fi

rsync -av ./config/PHPDS-defaults.config.php $DIR/config/PHPDS-defaults.config.php
rsync -av ./includes/ $DIR/includes/
rsync -av ./language/ $DIR/language/
rsync -av ./other/ $DIR/other/
rsync -av ./plugins/ $DIR/plugins/
rsync -av ./readme/ $DIR/readme/
rsync -av ./tests/ $DIR/tests/
rsync -av ./themes/ $DIR/themes/
rsync -av ./gzip.php $DIR/gzip.php
rsync -av ./index.php $DIR/index.php
rsync -av ./rename.htaccess $DIR/rename.htaccess