<?php

	require_once BASEPATH.'/includes/PHPDS_utils.inc.php';


	class PHPDS_utilsTest extends PHPUnit_Framework_TestCase
	{
		protected function setUp()
		{
		}
		
		public function testBuildGETArray()
		{
			$a = array('a' => true, 'B' => 10, 'c' =>'test');
			
			$this->assertEquals(array(), PU_BuildGETArray(array()));
			$this->assertEquals($a, PU_BuildGETArray($a));
			$this->assertEquals(array('a' => true, 'B' => 10, 'c' =>'test', 'D' => 'testing'), PU_BuildGETArray($a, array('D' => 'testing')));
			$this->assertEquals(array('a' => true, 'c' =>'test'), PU_BuildGETArray($a, null, array('B')));
			$this->assertEquals(array('a' => true, 'c' =>'test', 'D' => 'testing'), PU_BuildGETArray($a, array('D' => 'testing'), array('B')));
			
			$this->setExpectedException('PHPUnit_Framework_Error');
			PU_BuildGETArray('test');
		}
		
		public function testBuildGETString()
		{
			$this->assertEquals('', PU_BuildGETString(array()));
			$this->assertEquals('', PU_BuildGETString(array(), '&'));
			
			$this->assertEquals('?a=1', PU_BuildGETString(array('a' => 1)));
			$this->assertEquals('?a=1', PU_BuildGETString(array('a' => 1), '&'));
			
			$this->assertEquals('?a=1&amp;b=test', PU_BuildGETString(array('a' => 1, 'b' => 'test')));
			$this->assertEquals('?a=1&b=test', PU_BuildGETString(array('a' => 1, 'b' => 'test'), '&'));
			
			$this->assertEquals('?a=%26%20%C3%A9&amp;b=test', PU_BuildGETString(array('a' => '& é', 'b' => 'test')));
			$this->assertEquals('?a=%26%20%C3%A9&b=test', PU_BuildGETString(array('a' => '& é', 'b' => 'test'), '&'));
		}

		public function testBuildGET_Empty()
		{
			$_GET = array();

			$this->assertEquals('', PU_BuildGET(null,  null));
			//$this->assertEquals('', PU_BuildGET(array('a'),  null));
			//$this->assertEquals('?a=1', PU_BuildGET('a',  null));
			$this->assertEquals('?a=1', PU_BuildGET(array('a' => 1),  null));
			$this->assertEquals('?a=1&amp;b=y%20s', PU_BuildGET(array('a' => 1, 'b' => 'y s'),  null));
			$this->assertEquals('?a=1', PU_BuildGET(array('a' => 1, 'b' => 'y s'),  'b'));

			$this->assertEquals('?a=y%20s', PU_BuildGET(array('a' => 'y s'),  null));
			//$this->assertEquals('?a=1&b=y%20s', PU_BuildGET(array('a' => 1, 'b' => 'y s'),  '&'));
			$this->assertEquals('?a=1', PU_BuildGET(array('a' => 1, 'b' => 'y s'),  'b', '&'));
		}

		public function testBuildGET_NotEmpty()
		{
			$_GET = array('c' => 'no');

			$this->assertEquals('?c=no', PU_BuildGET(null,  null));
			$this->assertEquals('', PU_BuildGET(array('a'),  null));
			$this->assertEquals('?a=1', PU_BuildGET('a',  null));
			$this->assertEquals('?a=1', PU_BuildGET(array('a' => 1),  null));
			$this->assertEquals('?a=1&amp;b=y%20s', PU_BuildGET(array('a' => 1, 'b' => 'y s'),  null));
			$this->assertEquals('?a=1', PU_BuildGET(array('a' => 1, 'b' => 'y s'),  'b'));

			$this->assertEquals('?a=y%20s', PU_BuildGET(array('a' => 'y s'),  null));
			$this->assertEquals('?a=1&b=y%20s', PU_BuildGET(array('a' => 1, 'b' => 'y s'),  '&'));
			$this->assertEquals('?a=1', PU_BuildGET(array('a' => 1, 'b' => 'y s'),  'b', '&'));
		}

		public function testBuildURL()
		{
			//PU_BuildURL($target = null, $includeInGet = null, $excludeFromGet = null, $glue = '&amp;')
			$this->assertEquals('http://TEST/test.php', PU_BuildURL());
			$this->assertEquals('http://TEST/target.php', PU_BuildURL('/target.php'));
			$this->assertEquals('target.php', PU_BuildURL('target.php'));

			$this->assertEquals('target.php?a=z', PU_BuildURL('target.php', array('a' => 'z')));
			$this->assertEquals('target.php?a=1&amp;b=2', PU_BuildURL('target.php?a=1&b=2'));
			$this->assertEquals('target.php?a=z&amp;b=2', PU_BuildURL('target.php?a=1&b=2', array('a' => 'z')));
			$this->assertEquals('target.php?a=z&amp;b=2&amp;c=y', PU_BuildURL('target.php?a=1&b=2', array('a' => 'z', 'c' => 'y')));
			$this->assertEquals('target.php?a=1&amp;b=2&amp;c=y', PU_BuildURL('target.php?a=1&b=2', array('c' => 'y')));

			$this->assertEquals('target.php', PU_BuildURL('target.php', null, array('a')));
			$this->assertEquals('target.php?b=2', PU_BuildURL('target.php?a=1&b=2', null, array('a')));
			$this->assertEquals('target.php?b=2', PU_BuildURL('target.php?a=1&b=2', array('a' => 'z'), array('a')));
			$this->assertEquals('target.php?b=2&amp;c=y', PU_BuildURL('target.php?b=2', array('a' => 'z', 'c' => 'y'), array('a')));
			$this->assertEquals('target.php?c=y', PU_BuildURL('target.php?c=z', array('c' => 'y'), array('a')));
		}

		public function testBuildAttrString()
		{
			$this->assertEquals('', PU_BuildAttrString(array()));
			$this->assertEquals(' a="1"', PU_BuildAttrString(array('a' => 1)));
			$this->assertEquals(' a="1" b="y s"', PU_BuildAttrString(array('a' => 1, 'b' => 'y s')));
		}

		public function testCleanString()
		{
			$this->assertEquals('', PU_CleanString(''));
			$this->assertEquals('a', PU_CleanString('a'));
			$this->assertEquals('a', PU_CleanString('a"'));
			$this->assertEquals('ab', PU_CleanString('a"\'\\\\b"'));
		}
		
		public function testIsAjax()
		{
			$data = array('test' => true);
			
			$_SERVER["HTTP_X_REQUESTED_WITH"] = '';
			$_SERVER["HTTP_X_REQUESTED_TYPE"] = '';

			$this->assertFalse(PU_isAJAX());
			$this->assertEquals('', PU_isJSON($data));
			
			
			$_SERVER["HTTP_X_REQUESTED_WITH"] = 'XMLHttpRequest';
			$_SERVER["HTTP_X_REQUESTED_TYPE"] = '';

			$this->assertTrue(PU_isAJAX());
			$this->assertEquals('', PU_isJSON($data));
		}
		
		public function testIsJson()
		{
			$data = array('test' => true);
			
			$_SERVER["HTTP_X_REQUESTED_WITH"] = '';
			$_SERVER["HTTP_X_REQUESTED_TYPE"] = 'json';

			$this->assertFalse(PU_isAJAX());
			$this->assertEquals('', PU_isJSON($data));
			
			
			$_SERVER["HTTP_X_REQUESTED_WITH"] = 'XMLHttpRequest';
			$_SERVER["HTTP_X_REQUESTED_TYPE"] = 'json';

			$this->assertTrue(PU_isAJAX());
			$this->assertEquals('{"test":true}', PU_isJSON($data));
		}
		
		public function testarraycompact()
		{
			//PU_array_compact(array $a)
			$this->assertEquals(array(), PU_array_compact(array()));
			$this->assertEquals(array('a' => 1), PU_array_compact(array('a' => 1)));
			$this->assertEquals(array('a' => 1), PU_array_compact(array('a' => 1, 'b' => null)));
			$this->assertEquals(array('a' => 1, 'c' => 'test'), PU_array_compact(array('a' => 1, 'b' => null, 'c' => 'test')));
		}
		
		public function test_sprintfn()
		{	
			$this->assertEquals('', PU_sprintfn('', array()));
			$this->assertEquals('', PU_sprintfn('', array('a' => 'test')));
			
			$this->assertEquals('TEST', PU_sprintfn('TEST', array('a' => 'test')));
			$this->assertEquals('TEST test', PU_sprintfn('TEST %s', array('a' => 'test')));
			$this->assertEquals('TEST test', PU_sprintfn('TEST %1$s', array('a' => 'test')));
			$this->assertEquals('TEST test', PU_sprintfn('TEST %(a)s', array('a' => 'test')));
			
			$this->assertEquals('TEST right', PU_sprintfn('TEST %2$s', array('a' => 'wrong', 'b' => 'right')));
			$this->assertEquals('TEST right', PU_sprintfn('TEST %(b)s', array('a' => 'wrong', 'b' => 'right')));
			
			$this->setExpectedException('PHPDS_sprintfnException');
			PU_sprintfn('TEST %2$s', array('a' => 'wrong'));
			PU_sprintfn('TEST %(b)s', array('a' => 'wrong'));
		}
	}