<!-- PHPDevShell uses a 12 Grid system called 1KB Grid. -->
<div class="row">
	<div class="column grid_6">
		<article>
			<h1>
				{$script_name}
			</h1>
			<p>
				Thank you for installing PHPDevShell, if you can read this, it probably means that the installation went well,
				the system also connected to the database without problems. Now you can start writing your application inside PHPDevShell as plugins or plain linked scripts.
				Remember to check back at <a href="http://www.phpdevshell.org" title="Visit us for support, updates and faq.">phpdevshell.org</a> every now and then to see if you are running the latest version or use the plugin manager to check.
				PHPDevShell is constantly being worked on improving security, stability and speed.
			</p>
			<p>
				PHPDevShell will always try to keep true to "keep it light, keep it simple, keep it stable".
				This is so that we can continue to fully support, maintain and improve the system
				without worrying about cluttering functionality.
			</p>
			<p>
				For all support related queries please use our wiki located at  <a href="http://www.phpdevshell.org/content/official-documentation">docs.phpdevshell.org</a>.
				Here you will find documentation to help you get started as well, no documentation is provided with the distribution package.
				If you feel that you have a good idea to add or improve PHPDevShell,
				please share it with the community at  <a href="http://www.phpdevshell.org/content/official-documentation">docs.phpdevshell.org</a>.
			</p>
			<p>
				PHPDevShell is free software; you can redistribute it and/or
				modify it under the terms of the GNU Lesser General Public
				License as published by the Free Software Foundation; either
				version 2.1 of the License, or (at your option) any later version.
			</p>
			<p>
				PHPDevShell is distributed in the hope that it will be useful,
				but WITHOUT ANY WARRANTY; without even the implied warranty of
				MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
				Lesser General Public License for more details.
			</p>
			<p>
				You should have received a copy of the GNU Lesser General Public
				License along with this library; if not, write to the Free Software
				Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
			</p>
			<p>
				<small>Good luck and enjoy!</small>
			</p>
			<h2>Thanks</h2>
			<p>
				I would like to thank everyone involved in this project for their support and motivation.
				Special thanks goes to God and all the contributors of <a href="http://www.phpdevshell.org">PHPDevShell</a>.
			</p>
			<p>
				I would also like to thank all Open Source Projects used to make PHPDevShell possible, these projects include;
			</p>
			<p>
				Special thanks go to our sponsoring hosting provider, who provides reliable VPS/Cloud solutions and is a vivid pro open-source company:
			</p>
			<p>
				<a href="http://www.host1plus.com" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/host1plus.jpg" alt="Host1Plus" title="Host1Plus"></a>
			</p>
			<p>
				<a href="http://www.linux.org" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/linux.png" alt="Linux" title="Linux"></a>
				<a href="http://www.apache.org" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/apache.png" alt="Apache" title="Apache"></a>
				<a href="http://www.mysql.com" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/mysql.png" alt="MySQL" title="MySQL"></a>
				<a href="http://www.php.net" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/php.png" alt="PHP" title="PHP"></a>
				<a href="http://www.gnu.org" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/gnu.png" alt="GNU" title="GNU"></a>
				<a href="http://www.mozilla.org" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/firefox.png" alt="Firefox" title="Firefox"></a>
				<a href="http://www.smarty.net/" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/smarty.png" alt="Smarty" title="Smarty"></a>
				<a href="http://www.getfirebug.com/" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/firebug.png" alt="Firebug" title="Firebug"></a>
				<a href="http://www.firephp.org/" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/firephp.png" alt="FirePHP" title="FirePHP"></a>
				<a href="http://jquery.com/" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/jquery.png" alt="jQuery" title="jQuery"></a>
				<a href="http://phpmailer.codeworxtech.com/" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/phpmailer.png" alt="PHPMailer" title="PHPMailer"></a>
				<a href="http://www.gen-x-design.com/projects/php-thumbnailer-class/" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/phpthumb.png" alt="PHPThumb" title="PHPThumb"></a>
				<a href="http://tinymce.moxiecode.com/" style="padding: 3px;" class="ui-corner-all"><img src="{$aurl}/plugins/PHPDevShell/images/tinymce.png" alt="TinyMCE" title="TinyMCE"></a>
			</p>
			<p>
				Allot of work goes into a project like this, I ask nothing in return, however, sometimes I need a word of motivation.
				Please take a minute and say thanks, it would be nice to hear what PHPDevShell does for you.
			</p>
			<h3>You agree to this License when using PHPDevShell;</h3>
			<p>
				<strong>The GNU/LGPL 2.1 unlike GNU/GPL allows PHPDevShell to be used in proprietary software.</strong>
			</p>
			<p>
				Package : PHPDevShell is a RAD Framework aimed at developing administrative applications.<br />
				Copyright &copy; 2007 Jason Schoeman<br />
				Author: Jason Schoeman<br />
				Contact: titan [at] phpdevshell [dot] org.<br />
				Full license under <a href="readme/licensed_under_lgpl">/readme/licensed_under_lgpl</a><br />
				or<br />
				<a href="http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html">http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html</a><br />
			</p>
		</article>
	</div>
	<div class="column grid_6 last">
		<article>
            <h1>Some Features...</h1>
			<h2>Themes</h2>
			<p>
				Using the most stable and best HTML5 and CSS3 features the theme is what wraps your application. Standard elements are used, in other words, there is no need to learn endless classes to make your application look consistent on every page. Just type HTML in your view as you know it.
			</p>
			<p>
				It’s extremely easy to create your own theme, and it is 100% customizable to have a theme for your next application or website exactly how you would like it.
			</p>
			<p>
				Using <a href="http://www.1kbgrid.com/">1KB Grid</a>, we offer the simplest solution to do complicated layouts without using tables using the standard cloud theme.
				You are free to choose whatever CSS frameworks (if any) you like when designing your own theme.
			</p>
			<h2>JQuery Skins</h2>
			<p>On top of themes you can give color to your theme and widgets with skins.</p>
            <p>Make your theme seamlessly integrate and feel the same as Jquery widgets. The default theme comes with over 25 preset skins for those developers who prefer to develop rather then design. You can even create your own skins within minutes using the JQuery Theme Roller.</p>
            <p>You also have the power to wrap your skins inside the theme you design yourself. This powerful themes then gets extended and wrapped around your views. There really is no theme or layout you wont be able to create.</p>
			<form action="{$self_url}" method="post">
				<p>
					<label>{_e('Pick a skin')}
						<select name="skin" onchange="this.form.submit()" title="{_e('The skin you pick will be set as default skin.')}">
							<option value=""></option>
							{$skins}
						</select>
					</label><br>
					<input type="submit" name="submit" value="Submit">
					<input type="hidden" name="test" value="TESTER">
				</p>
			</form>
			<h2>Widget Preview</h2>
			{$error}
			{$warning}
			{$critical}
			{$ok}
			{$notice}
			{$busy}
			{$message}
			{$note}
			{$scripthead}
			<h2>Some Form Elements</h2>
			<p>
				<label>{_e('Text Field')}
					<input type="text" size="20" name="text" value="" title="{_e('Sample Text Title.')}">
				</label>
			</p>
			<p>
				<label>{_e('Text Field Required')}
					<input type="text" size="20" name="textreq" value="" required="required" title="{_e('Sample Required Text Title.')}">
				</label>
			</p>
			<p>
				<button type="submit" name="sample" value="sample"><span class="save"></span><span>{_e('Sample Button')}</span></button>
				<button type="submit" name="sample_" value="sample_"><span class="ui-icon ui-icon-transferthick-e-w left"></span><span>{_e('Another Sample Button')}</span></button>
			</p>
			<h2>Other Elements Styling</h2>
			<h1>Heading 1</h1>
			<h2>Heading 2</h2>
			<h3>Heading 3</h3>
			<h4>Heading 4</h4>
			<h5>Heading 5</h5>
			<h6>Heading 6</h6>
            <p>
				This is <abbr title="title">abbreviation</abbr><br>
				This is <strong>strong</strong><br>

				This is <em>emphasis</em><br>
				This is <b>bold text</b><br>
				This is <i>italic text</i><br>
				This is <cite>cite</cite><br>
				This is <small>small text</small><br>

				This is <del>deleted text</del><br>
				This is <ins>inserted text</ins><br>
				This is <dfn>defining instance</dfn><br>
				This is <kbd>user input</kbd><br>

				This is <samp>sample output</samp><br>
				This is <q>inline quotation</q> <br>
				These are <sub>subscript</sub> and <sup>superscript</sup><br>
				This is <var>a variable</var>
            </p>
			<h2>Tables</h2>
			<table>
				<caption><em>A test table with a thead, tfoot, and tbody elements</em></caption>
				<thead>
					<tr>
						<th>Table Header One</th>
						<th>Table Header Two</th>
						<th>Table Header Image</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>TD One</td>
						<td>TD Two</td>
						<td>{$urlbutton}</td>
					</tr>
					<tr>
						<td>TD One</td>
						<td>TD Two</td>
						<td>{$urlbutton}</td>
					</tr>
					<tr>
						<td>TD One</td>
						<td>TD Two</td>
						<td>{$urlbutton}</td>
					</tr>
					<tr>
						<td>TD One</td>
						<td>TD Two</td>
						<td>{$urlbutton}</td>
					</tr>
				</tbody>
				<tfoot>
					<tr>
						<td colspan="3">tfoot footer - some text for a footer or pagination</td>
					</tr>
				</tfoot>
			</table>
			<h2>User Interface Images</h2>
			<p>
				Pick from over three thousand images for your next applications ui functionality, this done with a simple function.
			</p>
			<p>
				{$img1} {$img2} {$img3} {$img4}
			</p>
		</article>
	</div>
</div>
