<?php
/**
 * Module.class.php
 *
 * DoitPHP系统module的基类
 * @author tommy <streen003@gmail.com>
 * @copyright  Copyright (c) 2010 Tommy Software Studio
 * @link http://www.doitphp.com
 * @license New BSD License.{@link http://www.opensource.org/licenses/bsd-license.php}
 * @version $Id: Module.class.php 1.0 2011-3-24 20:10:00Z tommy $
 * @package core
 * @since 1.0
 */

if (!defined('IN_DOIT')) {
    exit();
}

abstract class Module extends Controller {

    /**
     * 设置视图布局
     *
     * 注:Module不支持布局
     * @access public
     * @return boolean
     */
    public function setLayout() {

        return false;
    }

    /**
     * 设置视图主题
     *
     * 扩展module里本功能是不支持的,所以返回false
     * @access public
     * @return boolean
     */
    public function setTheme() {

        return false;
    }

    /**
     * 获取当前扩展module目录的路径
     *
     * @access public
     * @return string    目录的路径
     */
    public function getModuleRoot() {

        return MODULE_DIR . $this->getModuleName() . DIRECTORY_SEPARATOR;
    }

    /**
     * 获取当前Module目录的URL
     *
     * @access public
     * @return string    当前Moudle目录的URL
     */
    public function getModuleUrl() {

        return $this->getBaseUrl() . 'modules/' . $this->getModuleName() . '/';
    }

    /**
     * 扩展module的视图显示
     *
     * 注:扩展module的视图文件放在特定的目录里,所以扩展module不支持多种主题
     * @access public
     * @param sring $viewName 视图文件名
     * @param array $_data    视图变量数组(所要赋值的视图变量)
     * @return void
     */
    public function display($viewName = null, $_data = array()) {

        //参数分析
        $viewFile = $this->getViewFile($viewName);

        if (!empty($_data) && is_array($_data)) {
            extract($_data, EXTR_PREFIX_SAME, 'data');
            unset($_data);
        }

        ob_start();
        include $viewFile;
        echo ob_get_clean();
    }

    /**
     * 获取当前Module的名称
     *
     * @access protected
     * @return string    Module名称
     */
    protected function getModuleName() {

        return substr(strtolower(get_class($this)), 0, -6);
    }

    /**
     * 分析module的视图文件
     *
     */
    public function getViewFile($fileName = null) {

        //获取当前module文件路径
        $moduleName = $this->getModuleName();

        //参数分析
        if (!$fileName) {
            $fileName = $moduleName;
        }

        return MODULE_DIR . $moduleName . '/views/' . $fileName . '.php';
    }

    /**
     * 加载并显示视图片段文件内容
     *
     * @access public
     * @return void
     */
    public function render(){

        return false;
    }
}