<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

require_once PHPXI_PATH.'/core/function.php';
require_once PHPXI_PATH.'/core/uri.router.php';
require_once PHPXI_PATH.'/core/controller.php';
require_once PHPXI_PATH.'/core/loader.php';
require_once PHPXI_PATH.'/core/input.php';
require_once PHPXI_PATH.'/core/file.php';
if(file_exists(APP_PATH.'/config/config.php')){
	require_once(APP_PATH.'/config/config.php');
}

$PHPXI['uri'] = new PHPXI_URI_Router;
$PHPXI['uri']->router();

//controller
require_once $PHPXI['uri']->box['controller'];
if(!class_exists($PHPXI['uri']->box['router']['controller'])){
	show_msg('Error : Unable to load class '.$PHPXI['uri']->box['router']['controller']);exit;
}
//method
if(in_array($PHPXI['uri']->box['router']['method'],array_map('strtolower',get_class_methods('Controller')))){
	show_msg('Error : Controller Method '.$PHPXI['uri']->box['router']['method']);exit;
}
//初始化
$PHPXI['Controller'] = new $PHPXI['uri']->box['router']['controller'];
if(!method_exists($PHPXI['Controller'],$PHPXI['uri']->box['router']['method'])){
	show_msg('Method 404 : '.$PHPXI['uri']->box['router']['method']);exit;
}
call_user_func_array(array(&$PHPXI['Controller'],$PHPXI['uri']->box['router']['method']),array_slice((array)$PHPXI['uri']->box['segments'],isset($PHPXI['uri']->box['router']['app']) ? 3 : 2));
?>