<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

class File
{
	static public function read($var,$method = 'rb'){
		$w = '';
		if($fp= @fopen($var, $method)){
			flock($fp, LOCK_SH);
			$w = @fread($fp, filesize($var));
			fclose($fp);
		}
		return $w;
	}
	static public function write($var,$w,$method = 'rb+', $Lock = true,$Chmod = true){
		touch($var);
		$fp = fopen($var, $method);
		$Lock && flock($fp, LOCK_EX);
		fwrite($fp, $w);
		$method == 'rb+' && ftruncate($fp, strlen($w));
		fclose($fp);
		$Chmod && @chmod($var, 0777);
	}
	static public function unlink($var){
		return @unlink($var);
	}
	static public function del($var){
		return @unlink($var);
	}
	static public function makedir($dir, $mode = 0777) {
		if (is_dir($dir) || @mkdir($dir, $mode)) return true;
		if (!self::makedir(dirname($dir), $mode)) return false;
		return @mkdir($dir, $mode);
	}
	static public function scandir($var){
		if(!file_exists($var) || !is_dir($var)) return false;
		if(!$dir['d'] = @scandir($var)) return false;
		foreach($dir['d'] as $key => $val){
			if(is_dir($var.'/'.$val) && !in_array($val,array('.','..'))) $dir['var'][] = $val;
		}
		return $dir['var'];
	}
}
?>