<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
//随机字符串
function random($length) {
	$hash = '';
	$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz';
	$max = strlen($chars) - 1;
	PHP_VERSION < '4.2.0' && mt_srand((double)microtime() * 1000000);
	for($i = 0; $i < $length; $i++) {
		$hash .= $chars[mt_rand(0,$max)];
	}
	return $hash;
}
//对变量进行字符转换
function safe_var($var){
	if(is_array($var)){
		foreach($var as $key => $val){
			$var[$key] = safe_var($val);
		}
	}else if(!empty($var) && !is_numeric($var)){
		$var = str_replace(array("\0","%00","\r"),'',$var);
		$var = preg_replace(array('/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]/','/&(?!(#[0-9]+|[a-z]+);)/is'),array('','&amp;'),$var);
		$var = str_replace(array("%3C",'<'),'&lt;',$var);
		$var = str_replace(array("%3E",'>'),'&gt;',$var);
		$var = str_replace(array('"',"'"),array('&quot;','&#39;'),$var);
	}
	return $var;
}
//格式化时间函数
function fm_date($var,$style = ''){
	return array(
	    0 => $var,
		1 => date('Y-m-d',$var),
		2 => date('Y-m-d H:i',$var),
		3 => date('Y-m-d H:i:s',$var),
		4 => empty($style) ? '' : date($style,$var)
	);
}
//页面跳转函数
function _go($uri,$method = 'location'){
	$method  == 'refresh' ? header("Refresh:0;url=".$uri) : header("Location: ".$uri);exit;
}
function auto_bind($var,$params = array(),$marker = '?',$method = false){//method false:string,true :sql
	if(strpos($var,$marker) === false) return $var;
	
	$segments = explode($marker,$var);
	if (count($params) >= count($segments)){
		$params = array_slice($params, 0, count($segments)-1);
	}
	$str = $segments[0];$i = 1;
    foreach ($params as $bind){
		if($method && is_string($bind)){
			$str .= "'".$bind."'";
		}else if($method && is_bool($bind)){
			$str .= ($bind === false) ? 0 : 1;
		}else if($method && is_null($bind)){
			$str .= 'NULL';
		}else{
			$str .= $bind;
		}
		$str .= $segments[$i++];
    }
	return $str;
}
function page_size($page,$tpp,$count,$params = array(),$row = 10,$style = 1,$dot = '...',$marker = '@page'){
	$box['url']      = is_array($params) ? $params[0] : base_url();
	$box['params']   = is_array($params) ? array_slice($params,1) : '';
	
	$row -= strlen($page) - 1;
	if($row <= 0)  $row = 1;
	if($count <= $tpp) return '';
	
	$offset  = floor($row * 0.5);
	$maxpage = @ceil($count/$tpp);
	if($row > $maxpage) {
		$from = 1;$to = $maxpage;
	}else{
		$from = $page - $offset;
		$to = $from + $row - 1;
		if($from < 1) {
			$to = $page + 1 - $from;$from = 1;
			if($to - $from < $row) {$to = $row;}
		} elseif($to > $maxpage) {
			$from = $maxpage - $row + 1;$to = $maxpage;
		}
	}
	switch($style){
		case 1:
		    $box['style']  = '<div class="PageSize">';
			if($page - $offset > 1 && $maxpage > $row) $box['style'] .= '<a href="'.base_url(str_replace($marker,1,$box['url']),$box['params']).'" class="first">1 '.$dot.'</a>';
			if($page>1) $box['style'] .= '<a href="'.base_url(str_replace($marker,($page-1),$box['url']),$box['params']).'" class="prev">&nbsp;&nbsp;</a>';
			for($i = $from; $i <= $to; $i++) {
				$box['style'] .= $i == $page ? '<strong>'.$i.'</strong>' : '<a href="'.base_url(str_replace($marker,$i,$box['url']),$box['params']).'">'.$i.'</a>';
			}
			if($to < $maxpage) $box['style'] .= '<a href="'.base_url(str_replace($marker,$maxpage,$box['url']),$box['params']).'" class="last">'.$dot.' '.$maxpage.'</a>';
			if($maxpage>$page) $box['style'] .= '  <a href="'.base_url(str_replace($marker,($page+1),$box['url']),$box['params']).'" class="nxt">下一页</a>';
			$box['style'] .= '</div>';
		break;
	}
	return $box['style'];
}
//错误提示
function show_msg($var,$method = false){
	global $PHPXI;
	if($method === false){
		header("Content-type:text/html;charset=utf-8");
		exit($var);
	}else if($method === true && file_exists($path = APP_PATH.'/apps'.(isset($PHPXI['uri']->box['router']['app']) ? '/'.$PHPXI['uri']->box['router']['app'] : '').'/lang.php')){
		include_once($path);
		show_msg($lang[$var]);
	}else if(isset($PHPXI['uri']->box['router']['app']) && preg_match('/^[a-z|_]{1}([a-z0-9]|[_]){0,999}$/',$method) && file_exists($path = APP_PATH.'/apps/'.$method.'/lang.php')){
		include_once($path);
		show_msg($lang[$var]);
	}
	exit;
}
//获取当前url地址
function base_url($uri = '',$params = NULL){
	$box['base_url'] = 'http://localhost/';
	if(isset($_SERVER['HTTP_HOST'])){
		$box['base_url']  = isset($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) !== 'off' ? 'https' : 'http';
		$box['base_url'] .= '://'. $_SERVER['HTTP_HOST'];
		$box['base_url'] .= str_replace(basename($_SERVER['SCRIPT_NAME']), '', $_SERVER['SCRIPT_NAME']);
	}
	$box['base_url'] .= trim((is_array($uri) ? join('/',$uri) : $uri),'/');
	if(!is_null($params) && is_array($params)){
		$box['base_url'] = auto_bind($box['base_url'],$params);
	}
	return $box['base_url'];
}
//模板应用函数 example: include template('index');
function template($var){
	global $PHPXI;
	if(empty($var) || !is_object($PHPXI['uri'])) show_msg('Error : template 404');
	$box['obj'] = APP_PATH.(empty($PHPXI['uri']->box['router']['app']) ? '/static' : '/apps/'.$PHPXI['uri']->box['router']['app']).'/themes/'.$var.'.htm';
	$box['dir'] = APP_PATH.'/cache/templates'.(empty($PHPXI['uri']->box['router']['app']) ? '' : '/'.$PHPXI['uri']->box['router']['app']);
	$box['tpl'] = $box['dir'].'/'.$var.'.tpl.php';
	
	require_once PHPXI_PATH.'/core/template.php';
	return PHPXI_Template::view($box);
}
?>