<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

class PHPXI_Input
{
	private $ip_addr = false;
	public function __construct(){
		if(MAGIC_QUOTES_GPC){
			$_GET = $this->strip_slashes($_GET);
			$_POST = $this->strip_slashes($_POST);
			$_COOKIE = $this->strip_slashes($_COOKIE);
		}
	}
	public function post($key = NULL){
		return $this->getparams($_POST,$key);
	}
	public function get($key = NULL){
		return $this->getparams($_GET,$key);
	}
	public function request($key = NULL){
		return $this->getparams($_REQUEST,$key);
	}
	public function cookie($key = NULL,$pre = ''){
		return $this->getparams($_COOKIE,$pre.$key);
	}
	public function set_cookie($name = '',$value = '',$expire = 0,$path = '',$domain = '',$pre = '',$secure = false){
		if(is_array($name)){
			foreach($name as $key => $var){
				$this->set_cookie($key,$var,$expire,$path,$domain,$pre,$secure);
			}
			return;	
		}
		setcookie($pre.$name,$value,(is_numeric($expire) ? ($expire > 0 ? time()+$expire : 0) : time()-86400), $path, $domain, $secure);
		return true;
	}
	private function getparams(&$params,$key = NULL){
		if($key === NULL) return $params;
		return isset($params[$key]) ? $params[$key] : false;
	}
	public function ip(){
		if($this->ip_addr != false) return $this->ip_addr;
		$this->ip_addr = $_SERVER['REMOTE_ADDR'];
		if (isset($_SERVER['HTTP_CLIENT_IP']) && preg_match('/^([0-9]{1,3}\.){3}[0-9]{1,3}$/', $_SERVER['HTTP_CLIENT_IP'])) {
			$this->ip_addr = $_SERVER['HTTP_CLIENT_IP'];
		} elseif(isset($_SERVER['HTTP_X_FORWARDED_FOR']) && preg_match_all('#\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}#s', $_SERVER['HTTP_X_FORWARDED_FOR'],$matches)) {
			foreach ($matches[0] as $xip) {
				if (!preg_match('#^(10|172\.16|192\.168)\.#', $xip)) {$this->ip_addr = $xip;break;}
			}
		}
		return $this->ip_addr;
	}
	private function strip_slashes($string) {
		if(is_array($string)) {
			foreach($string as $key => $val) {
				$string[$key] = $this->strip_slashes($val);
			}
		} else {
			$string = stripslashes($string);
		}
		return $string;
	}
}
?>