<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

class PHPXI_Loader
{
	public $box = array(
	    'driver' => array('ftp'),
		//特殊的驱动
		'db'     => array('mysql','sqlite'),
		'memory' => array('memcache','xcache'),
		'router' => false,
	);
	public function __construct(){
		$this->box['router'] = $GLOBALS['PHPXI']['uri']->box['router'];
		//library
		include_once(PHPXI_PATH.'/core/library.php');
		//config.php
		global $config;
		if(is_array($config)){
			foreach($config as $key => $params){
				if(in_array($params['driver'],$this->box['db']) || in_array($params['driver'],$this->box['memory']) || in_array($params['driver'],$this->box['driver'])){
					$this->box['driver'][$key] = $this->driver($params['driver'],$params,$key);
				}else if($params['driver'] == 'library'){//config 加载 library
					if((isset($params['apps']) && isset($this->box['router']['app'])) && !in_array($this->box['router']['app'],explode(',',$params['apps']))) continue;
					$this->box['driver'][$key] = $this->library($params['path'],$params['params'],$params['object']);
				}
			}
		}
	}
	public function library($library = '', $params = NULL, $object_name = NULL){
		if(is_array($library)){
			foreach($library as $class){$this->library($class, $params);}
			return;
		}
		if(empty($library)) return false;
		if(in_array($library,$this->box['db']) || in_array($library,$this->box['memory']) || in_array($library,$this->box['driver'])){
			$path        = $this->getdriver($library);
			$object_name = is_null($object_name) ? $library : $object_name;
		}else if(!file_exists($path = strtolower(substr($library,-4))!= '.php' ? PHPXI_PATH.'/libraries/core/'.$library.'.php' : $library)){
			show_msg('Library 404 : '.$path);return false;
		}else if(is_null($object_name)){
			$pathinfo    = pathinfo($path);
			$object_name = $pathinfo['filename'];
		}
		include_once($path);
		if($this->safe_var($object_name = strtolower($object_name))){
			if(!class_exists($object_name)){
				show_msg('Library Object '.$object_name.' : '.$path);return false;
			}
			return new $object_name($params);
		} 
	}
	public function view($view,$vars = array()){
		if(is_array($vars)) extract($vars);
		include template($view);
	}
	public function driver($driver,$params = array(),$varkey = ''){
		$path = $this->getdriver($driver);
		include_once($path);
		if(!class_exists($driver)){
			show_msg('Driver lib 404 : '.$path);return false;
		}
		if(!empty($params['global']) && $this->safe_var($params['global'])){
			return $GLOBALS[$params['global']] = new $driver($params);
		}else if(empty($params['global']) && $this->safe_var($varkey)){
			return $GLOBALS[$varkey] = new $driver($params);
		}else{
			return new $driver($params);
		}
	}
	private function getdriver($driver){
		if(!in_array($driver,$this->box['driver']) && !in_array($driver,$this->box['db']) && !in_array($driver,$this->box['memory'])){
			show_msg('Driver 404 : '.$driver);return false;
		}
		if(in_array($driver,$this->box['db'])){
			$path = PHPXI_PATH.'/libraries/driver/db.'.$driver.'.php';
		}else if(in_array($driver,$this->box['memory'])){
			$path = PHPXI_PATH.'/libraries/driver/memory.'.$driver.'.php';
		}else{
			$path = PHPXI_PATH.'/libraries/driver/'.$driver.'.php';
		}
		if(!file_exists($path)){
			show_msg('Driver 404 : '.$path);return false;
		}
		return $path;
	}
	private function safe_var($var){//检查app,controller,method
		return preg_match('/^[a-z|_]{1}([a-z0-9]|[_]){0,999}$/',$var);
	}
}
?>