<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

class PHPXI_Template
{
	static public function view($var){
		if(!is_array($var) || empty($var['obj']) || empty($var['dir']) || empty($var['tpl'])) show_msg('Error : Template view');
		
		if(!file_exists($var['dir'])) File::makedir($var['dir']);
		if(@filemtime($var['obj']) < @filemtime($var['tpl'])) return $var['tpl'];
		
		if(!@$fp  = fopen($var['obj'],'r')) show_msg('Template 404 : '.$var['obj']);
		$var['w'] = @fread($fp,filesize($var['obj']));
		fclose($fp);
		
		$var['w'] = self::RegExp($var['w']);//正则分析
		if(!@$fp = fopen($var['tpl'],'w')) show_msg('Template 405 : '.$var['dir']);
		flock($fp,2);
		fwrite($fp,$var['w']);
		fclose($fp);
		return $var['tpl'];
	}
	static private function RegExp($w){
		$var = "((\\\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*(\-\>)?[a-zA-Z0-9_\x7f-\xff]*)(\[[a-zA-Z0-9_\-\.\"\'\[\]\$\x7f-\xff]+\])*)";
		$w = preg_replace("/([\n\r]+)\t+/s", "\\1", $w);
		$w = preg_replace("/\<\!\-\-\{(.+?)\}\-\-\>/s", "{\\1}", $w);
		$w = preg_replace("/\{lang\s+(.+?)\}/ies", "self::languagevar('\\1')", $w);
		$w = preg_replace("/\{(\\\$[a-zA-Z0-9_\[\]\'\"\$\.\x7f-\xff]+)\}/s", "<?=\\1?>", $w);
		$w = preg_replace("/$var/es", "self::addquote('<?=\\1?>')", $w);
		$w = preg_replace("/\<\?\=\<\?\=$var\?\>\?\>/es", "self::addquote('<?=\\1?>')", $w);
		$w = preg_replace("/[\n\r\t]*\{template\s+([a-z0-9_]+)\}[\n\r\t]*/is", "\n<? include template('\\1'); ?>\n", $w);
		$w = preg_replace("/[\n\r\t]*\{template\s+(.+?)\}[\n\r\t]*/ies","\n<? include template(\\1); ?>\n", $w);
		$w = preg_replace("/([\n\r\t]*)\{if\s+(.+?)\}([\n\r\t]*)/ies","self::gettags('\\1<? if(\\2) { ?>\\3')", $w);
		$w = preg_replace("/([\n\r\t]*)\{elseif\s+(.+?)\}([\n\r\t]*)/ies","self::gettags('\\1<? } elseif(\\2) { ?>\\3')", $w);
		$w = preg_replace("/\{else\}/i","<? } else { ?>", $w);
		$w = preg_replace("/\{\/if\}/i","<? } ?>", $w);
		$w = preg_replace("/[\n\r\t]*\{loop\s+(\S+)\s+(\S+)\}[\n\r\t]*/ies","self::gettags('<? if(is_array(\\1)) foreach(\\1 as \\2) { ?>')",$w);
		$w = preg_replace("/[\n\r\t]*\{loop\s+(\S+)\s+(\S+)\s+(\S+)\}[\n\r\t]*/ies","self::gettags('<? if(is_array(\\1)) foreach(\\1 as \\2 => \\3) { ?>')", $w);
		$w = preg_replace("/\{loop::break\}/i","<? break;?>", $w);
		$w = preg_replace("/\{loop::next\}/i","<? continue;?>", $w);
		$w = preg_replace("/\{\/loop\}/i", "<? } ?>", $w);
		$w = preg_replace("/\{([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)\}/s", "<?=\\1?>", $w);
		$w = preg_replace("/ \?\>[\n\r]*\<\? /s", " ", $w);
		return trim($w);
	}
	static private function languagevar($var){
		global $_Language;
		if(isset($_Language[$var])) {
			return $_Language[$var];
		}else{
			return "!$var!";
		}
	}
	static private function addquote($var){
		return str_replace("\\\"", "\"", preg_replace("/\[([a-zA-Z0-9_\-\.\x7f-\xff]+)\]/s", "['\\1']", $var));
	}
	static private function gettags($var,$v = ''){
		$var = str_replace("\\\"", "\"", preg_replace("/\<\?\=(\\\$.+?)\?\>/s", "\\1", $var));
		$v = str_replace("\\\"", "\"", $v);
		return $var.$v;
	}
}
?>