<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

class PHPXI_URI_Router
{
	public $box = array(
		'router' => array(),
	);
	public function __construct(){
		global $PHPXI;
		$this->set_router($PHPXI['router'],'init');//初始化设置
		$this->set_uri();
		$this->parse_uri();
	}
	public function router(){
		//app
		if(isset($this->box['router']['app']) && !file_exists(APP_PATH.'/apps/'.$this->box['router']['app'])){
			show_msg('Application 404 : '.APP_PATH.'/apps/'.$this->box['router']['app']);
			return false;
		}
		//controller
		$this->box['controller'] = APP_PATH.'/apps/'.(empty($this->box['router']['app']) ? '' : $this->box['router']['app'].'/').$this->box['router']['controller'].'.php';
		if(!file_exists($this->box['controller'])){
			show_msg('Controller 404 : '.$this->box['controller']);
			return false;
		}
	}
	private function parse_uri(){
		if(!$this->box['segments']) return false;
		//0
		$this->box['segments'][0] = strtolower($this->box['segments'][0]);
		if(!$this->safe_var($this->box['segments'][0])){
			show_msg((isset($this->box['router']['app']) ? 'Application' : 'Controller').' 404 : '.$this->box['segments'][0]);
			return false;
		}
		//1
		if(isset($this->box['segments'][1])){
			$this->box['segments'][1]  = strtolower($this->box['segments'][1]);
			if(!$this->safe_var($this->box['segments'][1])){
				show_msg((isset($this->box['router']['app']) ? 'Controller' : 'Method').' 404 : '.$this->box['segments'][1]);
				return false;
			}
		}
		//2
		if(isset($params['app']) && isset($this->box['segments'][2])){
			$this->box['segments'][2]  = strtolower($this->box['segments'][2]);
			if(!$this->safe_var($this->box['segments'][2])){
				show_msg('Method 404 : '.$this->box['segments'][2]);
				return false;
			}
		}
		$this->set_router($this->box['segments'],'auto');
	}
	private function set_uri(){
		if (!isset($_SERVER['REQUEST_URI']) || !isset($_SERVER['SCRIPT_NAME'])) return '';
		
		$box['uri'] = $_SERVER['REQUEST_URI'];
		if(strpos($box['uri'], $_SERVER['SCRIPT_NAME']) === 0){
			$box['uri'] = substr($box['uri'],strlen($_SERVER['SCRIPT_NAME']));
		}elseif (strpos($box['uri'], dirname($_SERVER['SCRIPT_NAME'])) === 0){
			$box['uri'] = substr($box['uri'],strlen(dirname($_SERVER['SCRIPT_NAME'])));
		}
		if (strncmp($box['uri'], '?/', 2) === 0) $box['uri'] = substr($box['uri'], 2);
		$box['parts'] = preg_split('#\?#i',$box['uri'], 2);
		$box['uri']   = $box['parts'][0];
		if ($box['uri'] == '/' || empty($box['uri'])) return '/';
		$box['uri']   = parse_url($box['uri'], PHP_URL_PATH);
		$box['uri']   = str_replace(array('//', '../'), '/', trim($box['uri'],'/'));
		
		$box['able']  = array('/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F]+/S');
		$box['uri']   = preg_replace($box['able'], '',$box['uri']);
		
		$box['uri']   = $box['uri']=='/' ? '' : $box['uri'];
		$this->box['uri'] = $box['uri'];
		
		$box['uri'] = explode("/", preg_replace("|/*(.+?)/*$|", "\\1",$box['uri']));
		$box['segments'] = false;
		foreach ($box['uri'] as $val){
			$val = trim(str_replace(array('$','(',')','%28','%29'),array('&#36;','&#40;','&#41;','&#40;','&#41;'),$val));
			if ($val != ''){
				$box['segments'][] = $val;
			}
		}
		$this->box['segments'] = $box['segments'];		
	}
	private function safe_var($var){//检查app,controller,method
		return preg_match('/^[a-z|_]{1}([a-z0-9]|[_]){0,999}$/',$var);
	}
	private function set_router($params,$method = false){
		switch($method)
		{
			case 'init'://初始化设置
			     $this->box['router'] = array(
					 'app'        => $params['app'],
					 'controller' => $params['controller'],
					 'method'     => $params['method'],
				 );
				 if(!isset($params['app'])) unset($this->box['router']['app']);
			break;
			case 'auto'://依据uri 自动识别
				if(isset($this->box['router']['app'])){
					$this->box['router']['app']        = isset($params[0]) ? $params[0] : $this->box['router']['app'];
			        $this->box['router']['controller'] = isset($params[1]) ? $params[1] : $this->box['router']['controller'];
				    $this->box['router']['method']     = isset($params[2]) ? $params[2] : $this->box['router']['method'];
				}else{
					$this->box['router']['controller'] = isset($params[0]) ? $params[0] : $this->box['router']['controller'];
					$this->box['router']['method']     = isset($params[1]) ? $params[1] : $this->box['router']['method'];
				}
			break;
		}
	}
}
?>