<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

class Image extends Library
{
	public $box = array(
	    'water' => array(
			'type'        => 1,//0-文字水印 1-图片水印
			'pos'         => 0,//水印位置
			'transparent' => 45,//水印透明度
			
			'text'        => '',//文字水印内容
			'fontsize'    => 16,//文字水印大小
			'fontcolor'   => array(255,0,255),//水印文字颜色(RGB)
			'fontfile'    => '2.ttf',//字体文件
			
			'image'       => '',//水印图片地址
		)
	);
	private $water  = array();//image,water,text,pos
	public function thumb($source,$thumb = '',$method = false){//thumb : 100*100,200*200
		if(empty($source) || empty($thumb)){
			show_msg('Image Thumb : 404');return false;
		}
		foreach(explode(',',$thumb) as $row){
			$box[0][$row] = $box[1][] = $this->do_thumb($source,substr($row,0,(int)strpos($row,'*')),substr($row,(int)strpos($row,'*')+1));
		}
		return count($box[(int)$method])==1 ? current($box[(int)$method]) : $box[(int)$method];
	}
	public function do_thumb($source,$w = 0,$h = 0){
		if(!(int)$w || !(int)$h) return;
		if(!file_exists($source)){
			show_msg('Image 404 : '.$source);return false;
		}
		$box['image'] = array_merge(pathinfo($source),getimagesize($source));
		$box['image']['width']  = $box['image'][0];
		$box['image']['height'] = $box['image'][1];
		$box['image']['ext']    = strtolower($box['image']['extension']);
		if(!in_array($box['image']['mime'],array('image/x-ms-bmp','image/jpeg','image/jpeg','image/gif','image/png'))){
			show_msg('Image Thumb : bmp/jpg/gif/png');return false;
		}
		if($box['image']['mime'] == 'image/gif'){
			$box['method'] = array('imagecreatefromgif','imagegif');
		}else if($box['image']['mime'] == 'image/x-ms-bmp'){
			$box['method'] = array('imagecreatefromwbmp','imagebmp');
		}else if(in_array($box['image']['mime'],array('image/jpeg','image/jpeg'))){
			$box['method'] = array('imagecreatefromjpeg','imagejpeg');
		}else{
			$box['method'] = array('imagecreatefrompng','imagepng');
		}
		$box['ratio'] = array(
		    'width'   => $w/$box['image']['width'],
			'height'  => $h/$box['image']['height']
		);
		$box['filename'] = $box['image']['dirname'].'/'.$box['image']['filename'].'('.$w.'x'.$h.').'.$box['image']['ext'];
		if($box['ratio']['width']>1 && $box['ratio']['height']>1) return $source;
		
		$box['im'] = $box['method'][0]($source);
		if(!function_exists("imagecreatetruecolor") || !@$box['obj'] = imagecreatetruecolor($w,$h)){
			$box['obj'] = imagecreate($w,$h);
		}
		if($w/$h < $box['image']['width']/$box['image']['height']){//高优先
			imagecopyresampled($box['obj'],$box['im'],0,0,($box['image']['width']-$w*$box['image']['height']/$h)/2,0,$w,$h,(($box['image']['height'])*($w/$h)),$box['image']['height']);
		}else{
			imagecopyresampled($box['obj'],$box['im'],0,0,0,($box['image']['height']-$h*$box['image']['width']/$w)/2,$w,$h,$box['image']['width'],(($box['image']['width'])/($w/$h)));
		}
		$box['method'][1] == 'imagejpeg' ? $box['method'][1]($box['obj'],$box['filename'],100) : $box['method'][1]($box['obj'],$box['filename']);
		imagedestroy($box['obj']);
		imagedestroy($box['im']);
		return $box['filename'];
	}
	public function watermask($source = '',$params = array()){
		if(!file_exists($source)){
			show_msg('Image watermask 404: '.$source);return false;
		}
		if(is_array($params)) $this->box['water'] = array_merge($this->box['water'],(array)$params);
		if(!file_exists($this->box['water']['image'])){
			show_msg('Image watermask 404: '.$this->box['water']['image']);return false;
		}
		
		$this->water['image']['info'] = $this->getimageinfo($source);
		$this->water['image']['im']   = $this->water['image']['info']['c.method']($source);
		if(!$this->box['water']['type']){
			$this->waterstr();
		}else{
			$this->water['water']['info'] = $this->getimageinfo($this->box['water']['image']);
			$this->water['water']['im']   = $this->water['water']['info']['c.method']($this->box['water']['image']);
			$this->waterimage();
		}
		$this->water['image']['info']['method']($this->water['image']['im'],$source);
		imagedestroy($this->water['image']['im']);
		imagedestroy($this->water['water']['im']);
		return true;
	}
	private function waterimage(){
		if($this->water['image']['info'][0]<$this->water['water']['info'][0] || $this->water['image']['info'][1]<$this->water['water']['info'][1]){
			show_msg('Image watermask : 水印图片过大');return false;
		}
		$this->waterpos();
		$box['cut'] = imagecreatetruecolor($this->water['water']['info'][0],$this->water['water']['info'][1]);
		imagecopy($box['cut'],$this->water['image']['im'],0,0,$this->water['pos_x'],$this->water['pos_y'],$this->water['water']['info'][0],$this->water['water']['info'][1]);
		imagecopy($box['cut'],$this->water['water']['im'],0,0,0,0,$this->water['water']['info'][0],$this->water['water']['info'][1]);
		imagecopymerge($this->water['image']['im'],$box['cut'],$this->water['pos_x'],$this->water['pos_y'],0,0,$this->water['water']['info'][0],$this->water['water']['info'][1],$this->box['water']['transparent']);
	}
	private function waterstr(){
		$box['rect']  = imagettfbbox($this->box['water']['fontsize'],0,$this->box['water']['fontfile'],$this->box['water']['text']);
		$box['width'] = abs($box['rect'][2]-$box['rect'][6]);
		$box['height']= abs($box['rect'][3]-$box['rect'][7]);
		
		$this->water['water']['im'] = imagecreatetruecolor($box['width'],$box['height']);
		imagealphablending($this->water['water']['im'],false);
		imagesavealpha($this->water['water']['im'],true);
		
		$box['alpha'] = imagecolorallocatealpha($this->water['water']['im'],255,255,255,127);
		imagefill($this->water['water']['im'],0,0,$box['alpha']);
		$box['color'] = imagecolorallocate($this->water['water']['im'],$this->box['water']['fontcolor'][0],$this->box['water']['fontcolor'][1],$this->box['water']['fontcolor'][2]);
		imagettftext($this->water['water']['im'],$this->box['water']['fontsize'],0,0,$this->box['water']['fontsize'],$box['color'],$this->box['water']['fontfile'],$this->box['water']['text']);
		$this->water['water']['info'] = array(0 => $box['width'],1 => $box['height']);
		$this->waterimage();
	}
	private function getimageinfo($path){
		$box = array_merge(pathinfo($path),getimagesize($path));
		switch($box[2]){
			case 1:
			    $box['method']   = 'imagegif';
				$box['c.method'] = 'imagecreatefromgif';
			break;
			case 2:
			    $box['method']   = 'imagejpeg';
				$box['c.method'] = 'imagecreatefromjpeg';
			break;
			case 3:
			    $box['method']   = 'imagepng';
				$box['c.method'] = 'imagecreatefrompng';
			break;
			default:
			    show_msg('Image watermask : 仅支持gif、jpg、png格式图片!');return false;
			break;
		}
		return $box;
	}
	private function waterpos(){
		switch($this->box['water']['pos']){
			case 1://上左
			    $this->water['pos_x'] = $this->water['pos_y'] = 0;
			break;
			case 2://上中
			    $this->water['pos_x'] = ($this->water['image']['info'][0]-$this->water['water']['info'][0])/2;
				$this->water['pos_y'] = 0;
			break;
			case 3://上右
			    $this->water['pos_x'] = $this->water['image']['info'][0]-$this->water['water']['info'][0];
				$this->water['pos_y'] = 0;
			break;
			case 4://中左
			    $this->water['pos_x'] = 0;
				$this->water['pos_y'] = ($this->water['image']['info'][1]-$this->water['water']['info'][1])/2;
			break;
			case 5://中中
			    $this->water['pos_x'] = ($this->water['image']['info'][0]-$this->water['water']['info'][0])/2;
				$this->water['pos_y'] = ($this->water['image']['info'][1]-$this->water['water']['info'][1])/2;
			break;
			case 6://中右
			    $this->water['pos_x'] = $this->water['image']['info'][0]-$this->water['water']['info'][0];
				$this->water['pos_y'] = ($this->water['image']['info'][1]-$this->water['water']['info'][1])/2;
			break;
			case 7://下左
			    $this->water['pos_x'] = 0;
				$this->water['pos_y'] = $this->water['image']['info'][1]-$this->water['water']['info'][1];
			break;
			case 8://下中
			    $this->water['pos_x'] = ($this->water['image']['info'][0]-$this->water['water']['info'][0])/2;
				$this->water['pos_y'] = $this->water['image']['info'][1]-$this->water['water']['info'][1];
			break;
			case 9://下右
				$this->water['pos_x'] = $this->water['image']['info'][0]-$this->water['water']['info'][0];
				$this->water['pos_y'] = $this->water['image']['info'][1]-$this->water['water']['info'][1];
			break;
			default://随机位置
			    $this->water['pos_x'] = rand(0,$this->water['image']['info'][0]-$this->water['water']['info'][0]);
				$this->water['pos_y'] = rand(0,$this->water['image']['info'][1]-$this->water['water']['info'][1]);
			break;
		}
	}
}
?>