<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

class Upload extends Library
{
	private $box = array(
	    'minsize'  => 0,
		'is_image' => false,
		'exts'     => 'exe,php',
		'dir'      => '/',
	);
	private $mime = array (
			//applications
			'ai'    => 'application/postscript',
			'eps'   => 'application/postscript',
			'exe'   => 'application/octet-stream',
			'doc'   => 'application/vnd.ms-word',
			'xls'   => 'application/vnd.ms-excel',
			'ppt'   => 'application/vnd.ms-powerpoint',
			'pps'   => 'application/vnd.ms-powerpoint',
			'pdf'   => 'application/pdf',
			'xml'   => 'application/xml',
			'odt'   => 'application/vnd.oasis.opendocument.text',
			'swf'   => 'application/x-shockwave-flash',
			// archives
			'gz'    => 'application/x-gzip',
			'tgz'   => 'application/x-gzip',
			'bz'    => 'application/x-bzip2',
			'bz2'   => 'application/x-bzip2',
			'tbz'   => 'application/x-bzip2',
			'zip'   => 'application/zip',
			'rar'   => 'application/x-rar',
			'tar'   => 'application/x-tar',
			'7z'    => 'application/x-7z-compressed',
			// texts
			'txt'   => 'text/plain',
			'php'   => 'text/x-php',
			'html'  => 'text/html',
			'htm'   => 'text/html',
			'js'    => 'text/javascript',
			'css'   => 'text/css',
			'rtf'   => 'text/rtf',
			'rtfd'  => 'text/rtfd',
			'py'    => 'text/x-python',
			'java'  => 'text/x-java-source',
			'rb'    => 'text/x-ruby',
			'sh'    => 'text/x-shellscript',
			'pl'    => 'text/x-perl',
			'sql'   => 'text/x-sql',
			// images
			'bmp'   => 'image/x-ms-bmp',
			'jpg'   => 'image/jpeg',
			'jpeg'  => 'image/jpeg',
			'gif'   => 'image/gif',
			'png'   => 'image/png',
			'tif'   => 'image/tiff',
			'tiff'  => 'image/tiff',
			'tga'   => 'image/x-targa',
			'psd'   => 'image/vnd.adobe.photoshop',
			//audio
			'mp3'   => 'audio/mpeg',
			'mid'   => 'audio/midi',
			'ogg'   => 'audio/ogg',
			'mp4a'  => 'audio/mp4',
			'wav'   => 'audio/wav',
			'wma'   => 'audio/x-ms-wma',
			// video
			'avi'   => 'video/x-msvideo',
			'dv'    => 'video/x-dv',
			'mp4'   => 'video/mp4',
			'mpeg'  => 'video/mpeg',
			'mpg'   => 'video/mpeg',
			'mov'   => 'video/quicktime',
			'wm'    => 'video/x-ms-wmv',
			'flv'   => 'video/x-flv',
			'mkv'   => 'video/x-matroska'
			);
	public function __construct($params = array()){
		if(!isset($params['minsize'])){
			$params['minsize'] = min((int)ini_get('post_max_size'),(int)ini_get('upload_max_filesize'),(int)ini_get('memory_limit'))*1024*1024;
		}
		$this->box = array_merge($this->box,(array)$params);
	}
	public function do_upload($field = 'fileField',$filename = ''){
		if(!isset($_FILES[$field]) || !is_uploaded_file($_FILES[$field]['tmp_name'])){
			show_msg('Upload : upload_no_file_selected');return false;
		}
		$params = array(
		    'file_temp'   => $_FILES[$field]['tmp_name'],
			'file_size'   => $_FILES[$field]['size'],
			'file_name'   => $_FILES[$field]['name'],
			'info'        => pathinfo($_FILES[$field]['name']),
			'mime_type'   => $this->getmimetype($_FILES[$field]['name']),
			//上传后文件名
			'filename'    => empty($filename) ? time().(rand()%100000) : $filename, 
		);
		$params['file_ext'] = strtolower($params['info']['extension']);
		$params['link']     = rtrim($this->box['dir'],'/').'/'.$params['filename'].'.'.$params['file_ext'];
		if($params['file_size']>$this->box['minsize']){
			show_msg('Upload minsize: '.($this->box['minsize']/1048576).'M');return false;
		}
		if(in_array($params['file_ext'],explode(',',$this->box['exts']))){
			show_msg('Upload exts: '.$this->box['exts']);return false;
		}
		if($this->box['is_image'] && !in_array($params['mime_type'],array('image/x-ms-bmp','image/jpeg','image/jpeg','image/gif','image/png','image/tiff'))){
			show_msg('Upload image : bmp/jpg/gif/png/tif');return false;
		}
		if(!@file_exists($this->box['dir'])) File::makedir($this->box['dir']);
		if(!@copy($params['file_temp'],$params['link'])){
			if (!@move_uploaded_file($params['file_temp'],$params['link'])){
				show_msg('Upload : upload_destination_erro');return false;
			}
		}
		return $params['link'];
	}
	public function getmimetype($filepath){
		$fmime = $this->mimedetect();
		switch($fmime) {
			case 'finfo':
				$finfo = finfo_open(FILEINFO_MIME);
				if ($finfo) 
					$type = @finfo_file($finfo, $filepath);
			break;
			case 'mime_content_type':
				$type = mime_content_type($filepath);
			break;
			case 'linux':
				$type = exec('file -ib '.escapeshellarg($filepath));
			break;
			case 'bsd':
				$type = exec('file -Ib '.escapeshellarg($filepath));
			break;
			default:
				$pinfo = pathinfo($filepath);
				$ext   = isset($pinfo['extension']) ? strtolower($pinfo['extension']) : '';
				$type  = isset($this->mime[$ext]) ? $this->mime[$ext] : 'unkown';
			break;
		}
		$type = explode(';', $type);
		
		if ($fmime != 'internal' AND $type[0] == 'application/octet-stream') {
			$pinfo = pathinfo($filepath); 
			$ext = isset($pinfo['extension']) ? strtolower($pinfo['extension']) : '';
			if (!empty($ext) AND !empty($this->mime[$ext])) {
				$type[0] = $this->mime[$ext];
			}
		}
		
		return $type[0];
	}
	private function mimedetect(){
		if (class_exists('finfo')) {
			return 'finfo';
		} else if (function_exists('mime_content_type')) {
			return 'mime_content_type';
		} else if ( function_exists('exec')) {
			$result = exec('file -ib '.escapeshellarg(__FILE__));
			if ( 0 === strpos($result, 'text/x-php') OR 0 === strpos($result, 'text/x-c++')) {
				return 'linux';
			}
			$result = exec('file -Ib '.escapeshellarg(__FILE__));
			if ( 0 === strpos($result, 'text/x-php') OR 0 === strpos($result, 'text/x-c++')) {
				return 'bsd';
			}
		}
		return 'internal';
	}
}
?>