<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

class Mysql extends Driver
{
	public $box;
	public function __construct($params = array()){
		$params['timeout'] = !(int)$params['timeout'] ? 3 : $params['timeout'];
		$this->config      = $params;
		$this->box['pre']  = $this->config['db_pre'];
	}
	public function connect(){
		if(!$conf = $this->config) $this->halt('请配置数据库参数!');
		//ini_set('mysql.connect_timeout',$conf['timeout']);
		$func = !$conf['db_link'] ? 'mysql_connect' : 'mysql_pconnect';
		if(!$link = @$func($conf['db_host'],$conf['db_user'],$conf['db_pwd'],true)){
			$this->halt('Driver Mysql : Can not connect to MySQL server');
		}else{
			if(mysql_get_server_info($link)> '4.1'){
				$w  = $conf['db_charset'] ? 'character_set_connection='.$conf['db_charset'].', character_set_results='.$conf['db_charset'].', character_set_client=binary' : '';
				$w .= mysql_get_server_info($link) > '5.0.1' ? ((empty($conf['db_charset']) ? '' : ',').'sql_mode=\'\'') : '';
				$conf['db_charset'] && mysql_query('SET '.$w,$link);
			}
			if($conf['db_name'] && !@mysql_select_db($conf['db_name'],$link)) $this->halt('Driver Mysql : Cannot use database');
		}
		unset($this->config);
		return $link;
	}
	public function query($sql,$type = ''){
		if(!$this->box['link']) $this->box['link'] = $this->connect();
		$func = $type == 'UNBUFFERED' && @function_exists('mysql_unbuffered_query') ? 'mysql_unbuffered_query' : 'mysql_query';
		$this->free_result();//释放上一次查询内存
		if(!($this->box['query'] = $func($sql,$this->box['link'])) && $type != 'SILENT') $this->halt('Driver Mysql : '.mysql_errno($this->box['link']).' => '.mysql_error($this->box['link']).'<br /> Sql : '.$sql);
		return $this->box['query'];
	}
	public function fetch_array($query,$type = MYSQL_ASSOC){
		return mysql_fetch_array($query,$type);
	}
	public function result($query, $row = 0) {
		return @mysql_result($query, $row);
	}
	public function fetch_fields($query) {
		return mysql_fetch_field($query);
	}
	public function fetch_row($query) {
		return mysql_fetch_row($query);
	}
	public function num_rows($query) {
		return mysql_num_rows($query);
	}
	public function num_fields($query) {
		return mysql_num_fields($query);
	}
	public function affected_rows() {
		return mysql_affected_rows($this->box['link']);
	}
	public function free_result(){
		return $this->box['query'] ? mysql_free_result($this->box['query']) : true;
	}
	public function error(){
		return (($this->box['link']) ? mysql_error($this->box['link']) : mysql_error());
	}
	public function errno(){
		return intval(($this->box['link']) ? mysql_errno($this->box['link']) : mysql_errno());
	}
	public function insert_id(){
		return ($id = mysql_insert_id($this->box['link'])) >= 0 ? $id : $this->result($this->query('SELECT last_insert_id()'));
	}
	public function close() {
		return mysql_close($this->box['link']);
	}
	public function version(){
		return mysql_get_server_info($this->box['link']);
	}
	public function add($table,$param,$method = false){
		if(empty($table) || empty($param) || !is_array($param)) return false;
		$this->query('insert into `'.$table.'` set '.$this->SafeSql($method ? $param : safe_var($param)));
		return $this->insert_id();
	}
	public function addr($table,$param,$method = false){
		if(empty($table) || empty($param) || !is_array($param)) return false;
		$this->query('replace into `'.$table.'` set '.$this->SafeSql($method ? $param : safe_var($param)));
		return $this->insert_id();
	}
	public function set($table,$sqlw,$param,$method = false){
		if(empty($param) || !is_array($param)) return false;
		if(!preg_match('/where/i',$sqlw) && !empty($sqlw)) $sqlw = ' where '.$sqlw;
		$this->query('update `'.$table.'` set '.$this->SafeSql($method ? $param : safe_var($param)).' '.$sqlw);
		return true;
	}
	public function del($table,$sqlw = ''){
		if(!preg_match('/where/i',$sqlw) && !empty($sqlw)) $sqlw = ' where '.$sqlw;
		$this->query('delete from `'.$table.'` '.$sqlw);
		return true;
	}
	public function Read($sql){
		$sql = !preg_match('/limit/i',$sql) ? preg_replace('/[,;]$/i','',trim($sql)).' limit 1;' : $sql;
		$query = $this->query($sql);
		return $this->fetch_array($query);
	}
	public function Value($sql){
		$sql = !preg_match('/limit/i',$sql) ? preg_replace('/[,;]$/i','',trim($sql)).' limit 1;' : $sql;
		$query = $this->query($sql);
		return $this->result($query);
	}
	public function PageSize($var,$page = 1,$tpp = 50,$method = false){
		if(!is_array($var) || empty($var['sql']) || (!empty($var['count']) && (!(int)$page || !(int)$tpp))) return false;
		$page = max(1,(int)$page);
		$box  = false;
		$var['sql'] = !preg_match('/limit/i',$var['sql']) ? preg_replace('/[,;]$/i','',trim($var['sql'])).' limit '.($page-1)*$tpp.','.$tpp.';' : $var['sql'];
		$query = $this->query($var['sql']);
		while($res = $this->fetch_array($query)){
			$box[0][] = $res;
		}
		if(empty($var['count'])) return $box[0];
		$query = $this->query($var['count']);
		$box[1]= (int)$this->result($query);
		$box[2]= page_size($page,$tpp,$box[1],$var['url']);
		return $box;
	}
	public function _Sqllike($column,$keyword,$method = 'or',$row = 3){
		if(empty($column) || empty($keyword)) return '';
		$keyword = explode(' ',preg_replace('/\s+/',' ',trim($keyword)));//关键字以空格切割
		foreach($keyword as $key1 => $val1){
			if($key1>=$row) break;
			foreach(explode(',',$column) as $key2 => $val2){
				$box[] = $val2." like '%".$val1."%'";
			}
		}
		return is_array($box) ? ' ('.join(' '.$method.' ',$box).') ' : '';
	}
	public function SafeSql($var,$strip = true,$type = true){
		if(!$type){
			if(is_array($var)){
				foreach ($var as $key => $value) $var[$key] = trim($this->SafeSql($value,$strip,false));
				return $var;
			}else if(is_numeric($var)){
				return " '".$var."' ";
			}else{
				return " '".addslashes($strip ? stripslashes($var) : $var)."' ";
			}
		}else{
			$w = '';
			$array = $this->SafeSql($var,$strip,false);
			foreach($array as $key => $val){
				$w .= ($w ? ", " : " ").$key.'='.$val;
			}
			return $w;
		}
	}
	public function Table($var){
		return $this->box['pre'].$var;
	}
	public function __destruct(){
		if($this->box['link']) $this->close();
	}
}
?>