<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

class Sqlite extends Driver
{
	public $box;
	public function __construct($params = array()){
		$this->config      = $params;
		$this->box['pre']  = $this->config['db_pre'];
	}
	public function connect(){
		if(!$conf = $this->config) $this->halt('Driver Sqlite : 请配置数据库参数!');
		$func = $conf['link'] == 1 ? 'sqlite_popen' : 'sqlite_open';
		if(!$link = @$func($conf['db_file'],0666,$error)){
			$this -> halt($error);
		}
		unset($this->config);
		return $link;
	}
	public function query($sql,$type = ''){
		if(!$this->box['link']) $this->box['link'] = $this->connect();
		$error = '';
		$func = $type == 'UNBUFFERED' ? 'sqlite_unbuffered_query' : 'sqlite_query';
		if(preg_match("/^\s*SELECT/i", $sql)) {
			$query = $func($this->box['link'],$sql,SQLITE_ASSOC,$error);
		}else{
			$query = sqlite_exec($this->box['link'],$sql,$error);
		}
		if($error) $this->halt('Driver Sqlite : '.$error.' => '.$sql);
		return $query;
	}
	public function fetch_array($query, $result_type = SQLITE_ASSOC) {
		return sqlite_fetch_array($query, $result_type);
	}
	public function result($query, $row) {
		return @sqlite_fetch_all($query, SQLITE_ASSOC);
	}
	public function fetch_row($query) {
		return sqlite_fetch_array($query, SQLITE_NUM);
	}
	public function fetch_assoc($query){
		return $this->fetch_array($query,SQLITE_ASSOC);
	}
	public function insert_id(){
		return @sqlite_last_insert_rowid($this->box['link']);
	}
	public function version() {
		return sqlite_libversion();
	}
	public function close(){
		@sqlite_close($this->box['link']);
	}
	public function error() {
		return sqlite_error_string($this->box['link']);
	}
	public function errno(){
		return sqlite_last_error($this->box['link']);
	}
	public function add($table,$param,$method = false){
		if(empty($table) || empty($param) || !is_array($param)) return false;
		$box = $this->SafeSql($method ? $param : safe_var($param),false);
		$this->query('insert into '.$table.' ('.$box[0].') values ('.$box[1].') ');
		return $this->insert_id();
	}
	public function addr($table,$param,$method = false){
		if(empty($table) || empty($param) || !is_array($param)) return false;
		$box = $this->SafeSql($method ? $param : safe_var($param),false);
		$this->query('replace into '.$table.' ('.$box[0].') values ('.$box[1].') ');
		return $this->insert_id();
	}
	public function set($table,$sqlw,$param,$method = false){
		if(empty($param) || !is_array($param)) return false;
		if(!preg_match('/where/i',$sqlw) && !empty($sqlw)) $sqlw = ' where '.$sqlw;
		$this->query('update '.$table.' set '.$this->SafeSql($method ? $param : safe_var($param)).' '.$sqlw);
		return true;
	}
	public function del($table,$sqlw = ''){
		if(!preg_match('/where/i',$sqlw) && !empty($sqlw)) $sqlw = ' where '.$sqlw;
		$this->query('delete from `'.$table.'` '.$sqlw);
		return true;
	}
	public function Read($sql){
		$sql = !preg_match('/limit/i',$sql) ? preg_replace('/[,;]$/i','',trim($sql)).' limit 1;' : $sql;
		$query = $this->query($sql);
		return $this->fetch_array($query);
	}
	public function Value($sql){
		$sql = !preg_match('/limit/i',$sql) ? preg_replace('/[,;]$/i','',trim($sql)).' limit 1;' : $sql;
		$query = $this->query($sql);
		$box   = $this->fetch_row($query);
		return is_array($box) ? $box[0] : $box;
	}
	public function PageSize($var,$page = 1,$tpp = 50,$method = false){
		if(!is_array($var) || empty($var['sql']) || (!empty($var['count']) && (!(int)$page || !(int)$tpp))) return false;
		$page = max(1,$page);
		$box  = false;
		$var['sql'] = !preg_match('/limit/i',$var['sql']) ? preg_replace('/[,;]$/i','',trim($var['sql'])).' limit '.($page-1)*$tpp.','.$tpp.';' : $var['sql'];
		$query = $this->query($var['sql']);
		while($res = $this->fetch_array($query)){
			$box[0][] = $res;
		}
		if(empty($var['count'])) return $box[0];
		$box[1]= $this->Value($var['count']);
		$box[2]= page_size($page,$tpp,$box[1],$var['url']);
		return $box;
	}
	public function _Sqllike($column,$keyword,$method = 'or',$row = 3){
		if(empty($column) || empty($keyword)) return '';
		$keyword = explode(' ',preg_replace('/\s+/',' ',trim($keyword)));//关键字以空格切割
		foreach($keyword as $key1 => $val1){
			if($key1>=$row) break;
			foreach(explode(',',$column) as $key2 => $val2){
				$box[] = $val2." like '%".$val1."%'";
			}
		}
		return is_array($box) ? ' ('.join(' '.$method.' ',$box).') ' : '';
	}
	public function SafeSql($var,$method = true,$strip = true,$type = true){
		if(!$type){
			if(is_array($var)){
				foreach ($var as $key => $value) $var[$key] = trim($this->SafeSql($value,$method,$strip,false));
				return $var;
			}else if(is_numeric($var)){
				return " '".$var."' ";
			}else{
				return " '".addslashes($strip ? stripslashes($var) : $var)."' ";
			}
		}else{
			$w = '';
			$array = $this->SafeSql($var,$method,$strip,false);
			foreach($array as $key => $val){
				if($method){
					$w .= ($w ? ", " : " ").$key.'='.$val;
				}else{
					$w[0][] = $key;$w[1][] = $val;
				}
			}
			return is_array($w) ? array(join(',',$w[0]),join(',',$w[1])) : $w;
		}
	}
	public function Table($var){
		return $this->box['pre'].$var;
	}
	public function __destruct(){
		if($this->box['link']) $this->close();
	}
}
?>