<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

class FTP extends Driver
{
	private $box = array(
	    'ssl'            => 0,//ssl 链接 0-关闭 1-开启
		'pasv'           => 1,//被动模式 0-关闭 1-开启
		'timeout'        => 0,//超时时间 单位 秒
		'disallowedexts' => 'exe,doc',//禁止文件扩展名 多个以","隔开
		'host'           => '',//FTP服务器ip
		'port'           => 21,//端口
		'username'       => '',//ftp账户
		'password'       => '',//ftp密码
		'chdir'          => '/',//默认远程目录
		'link'           => '',//网络访问url
	);
	public function __construct($params = array()){
		$this->config = array_merge($this->box,(array)$params);
	}
	public function connect(){
		if($this->box['link']) return true;
		if(!$conf = $this->config) $this->halt('Driver FTP : 请配置FTP参数!');
		$this->box['func'] = $conf['ssl'] && function_exists('ftp_ssl_connect') ? 'ftp_ssl_connect' : 'ftp_connect';
		if($this->box['func'] == 'ftp_connect' && !function_exists('ftp_connect')) $this->halt('Driver FTP : FTP not supported.');
		
		if($this->box['link'] = $this->box['func']($conf['host'],(int)$conf['port'],20)){
			(int)$conf['timeout'] && $this->set_option(FTP_TIMEOUT_SEC,(int)$conf['timeout']);
			if(@ftp_login($this->box['link'],$conf['username'],$conf['password'])){
				@ftp_pasv($this->box['link'],(int)$conf['pasv'] ? true : false);
				if(!$this->_chdir($conf['chdir'])){
					$this->halt('Driver FTP : Chdir '.$conf['chdir'].' error.');
				}
			}else{
				$this->halt('Driver FTP : 530 Not logged in.');
			}
		}else{
			$this->halt("Driver FTP : Couldn't connect to ".$conf['host'].":".(int)$conf['port']);
		}
	}
	public function upload($source,$target){		
		$dir      = $this->_pwd();
		$dirname  = dirname($target);
		$filename = basename($target);
		if(!$this->_chdir($dirname)){
			if($this->_mkdir($dirname)){
				$this->_chmod($dirname);
				if(!$this->_chdir($dirname)) $this->halt('Driver FTP : 返回目录：'.$dirname.'失败.');
			}
		}
		if(!is_readable($source)) $this->halt('Driver FTP : 文件无读取权限!');

		$state = $this->_put($target,$source,FTP_BINARY);
		$this->_chdir($dir);
		
		return $state;
	}
	public function get($localfile,$serverfile,$mode = FTP_BINARY,$resumepos = 0){
		$this->connect();
		return @ftp_get($this->box['link'],$this->clear($localfile),$this->clear($serverfile),(int)$mode,(int)$resumepos);
	}
	public function size($var){
		$this->connect();
		return @ftp_size($this->box['link'],$this->clear($var));
	}
	public function del($var){//删除文件
		$this->connect();
		return @ftp_delete($this->box['link'],$this->clear($var));
	}
	public function _fput($file1,$file2,$mode = FTP_BINARY){//上传打开中的文件
		$this->connect();
		return @ftp_fput($this->box['link'],$this->clear($file1),$file2,(int)$mode);
	}
	public function _put($file1,$file2,$mode = FTP_BINARY){
		$this->connect();
		return @ftp_put($this->box['link'],$this->clear($file1),$file2,(int)$mode);
	}
	public function _mkdir($var){
		$this->connect();
		$epath = explode('/',$this->clear($var));
		$dir = '';$comma = '';
		foreach($epath as $path) {
			$dir .= $comma.$path;
			$comma = '/';
			$return = @ftp_mkdir($this->box['link'],$dir);
			$this->_chmod($dir);
		}
		return $return;
		
	}
	public function _rmdir($var){//删除远程目录(必须是一个空目录)
		$this->connect();
		return @ftp_rmdir($this->box['link'],$this->clear($var));
	}
	public function _site($var){
		$this->connect();
		return @ftp_site($this->box['link'],$this->clear($var));
	}
	public function _pwd() {//返回当前目录
		$this->connect();
		return @ftp_pwd($this->box['link']);
	}
	public function _chdir($var){
		return @ftp_chdir($this->box['link'],$this->clear($var));
	}
	public function clear($str) {
		return str_replace(array( "\n", "\r", '..'), '', $str);
	}
	public function _chmod($filename, $mod = 0777) {
		$this->connect();
		$filename = $this->clear($var);
		if(function_exists('ftp_chmod')) {
			return @ftp_chmod($this->box['link'], $mod, $filename);
		} else {
			return @ftp_site($this->box['link'], 'CHMOD '.$mod.' '.$filename);
		}
	}
	public function set_option($cmd, $value) {
		$this->connect();
		if(function_exists('ftp_set_option')) {
			return @ftp_set_option($this->box['link'], $cmd, $value);
		}
	}
	public function close(){
		@ftp_close($this->box['link']);
	}
	public function __destruct(){
		if($this->box['link']) $this->close();
	}
}
?>