<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

class Memcache extends Driver
{
	private $box = array(
		'object'   => 'Memcached',
		'pconnect' => false,
		'timeout'  => 1,//秒
		'prefix'   => 'cache_',
		'link'     => false,
		'server'   => '',//array('host' => '','port' => '')
	);
	public function __construct($params = array()){
		$this->box = array_merge($this->box,(array)$params);
		if(!class_exists($this->box['object'])){
			show_msg('Memcache Error : Unable to load class '.$this->box['object']);exit;
		}
		if(!is_array($this->box['server'])){
			show_msg('Memcache Error : Server');exit;
		}else if(isset($this->box['server']['host'])){
			$this->box['server'] = array(0 => array('host' => $this->box['server']['host'],'port' => $this->box['server']['port']));
		}
		$this->box['link'] = new $this->box['object'];
		foreach($this->box['server'] as $key => $row){
			$this->box['link']->addServer($row['host'],!(int)$row['port'] ? 11211 : $row['port']);
		}
		if($this->box['object'] != 'Memcached') return true;
		$this->box['link']->setOption(Memcached::OPT_NO_BLOCK, true);//不阻塞,使用异步IO
		$this->box['link']->setOption(Memcached::OPT_TCP_NODELAY, true);//使用no-delay特性连接在某些场合可能更快
		$this->box['link']->setOption(Memcached::OPT_POLL_TIMEOUT, $this->box['timeout']*1000);//polling 连接的超时 毫秒
		$this->box['link']->setOption(Memcached::OPT_RETRY_TIMEOUT, 1);//连接失败后重试的时间间隔，单位秒
		$this->box['link']->setOption(Memcached::OPT_CONNECT_TIMEOUT, $this->box['timeout']*1000);//在异步模式下，连接超时时间，单位毫秒
		$this->box['link']->setOption(Memcached::OPT_LIBKETAMA_COMPATIBLE, true);//一种hash算法。如果使用consistent的分布式方式，强烈推荐将此设为true.
		$this->box['link']->setOption(Memcached::OPT_DISTRIBUTION,Memcached::DISTRIBUTION_CONSISTENT);//一致性方式，设置该值推荐OPT_LIBKETAMA_COMPATIBLE 也同时设为true
		$this->box['link']->setOption(Memcached::OPT_COMPRESSION,true);//小于100字节不压缩
	}
	public function set($key,$val,$ttl = 0){
		if(!is_object($this->box['link'])) return false;
		$this->box['object'] != 'Memcached' ? $this->box['link']->set(md5($key),$val,MEMCACHE_COMPRESSED,$ttl) : $this->box['link']->set(md5($key),$val,$ttl ? time()+$ttl : $ttl);;
	}
	public function get($key){
		if(!is_object($this->box['link'])) return false;
		return $this->box['link']->get(md5($key));
	}
	public function remove($key){
		$this->del($key);
	}
	public function del($key){
		if(!is_object($this->box['link'])) return false;
		$this->box['link']->delete(md5($key));
	}
	public function clear(){
		if(!is_object($this->box['link'])) return false;
		$this->box['link']->flush(0);
	}
}