<?php
/**
 * phpxi
 *
 * An open source application development framework for PHP 5.x or newer
 *
 * @package		phpxi
 * @author		dv.zhan
 * @copyright	Copyright (c) 2012-~ by dv.zhan
 * @link		http://www.phpxi.com
 * @since		Version 1.0.0
 */
if (!defined('PHPXI_PATH')) exit('No direct script access allowed');

class Xcache extends Driver
{
	private $box = array(
		'prefix' => 'cache_',
		'link'   => false,
	);
	public function __construct($params = array()){
		$this->box = array_merge($this->box,(array)$params);
		if(!function_exists('xcache_get')){
			show_msg('Xcache Error : xcache_get');return false;
		}
		$this->box['link'] = true;
	}
	public function _isset($key){
		return $this->box['link'] ? xcache_isset(md5($this->box['prefix'].$key)): false;
	}
	public function get($key){
		return $this->box['link'] ? xcache_get(md5($this->box['prefix'].$key)) : false;
	}
	public function set($key,$val,$ttl = 0){
		return $this->box['link'] ? xcache_set(md5($this->box['prefix'].$key),$val,$ttl) : false;
	}
	public function remove($key){
		return $this->box['link'] ? $this->del($key) : false;
	}
	public function del($key){
		return $this->box['link'] ? xcache_unset(md5($this->box['prefix'].$key)) : false;
	}
}