<?php

/************************************************
 *
 * 模型数据层 (M)
 * @param Object	$MysqlConnect	当前数据链接
 * @param String	$Affected		影响数
 * @param String	$InsertId		新增ID
 * @param String	$ResultSum		结果集数量
 * @param String	$QueryStatus	查询状态
 *
 */
class AirModel {
	
	public $MysqlConnect;
	public $Affected;
	public $InsertId;
	public $ResultSum;
	public $QueryStatus;
	public $SqlBug = '';
	private $queryCount = 9;
	private $result;

	/**
	 * 基本查询
	 * @param	string	$sql	SQL语句
	 * @return	Object 			结果集
	 */
	public function _query($sql) 
	{
		global $Config;
		if(!$this -> MysqlConnect) Return false;
		$this -> QueryStatus = '(0)';
		$this -> Affected = 0;
		if($Config['DebugSql']) $this -> SqlBug .= "\n". '<!--DebugSql: ' . $sql . '-->' . "\n";
		$result = mysql_query($sql, $this -> MysqlConnect);
		if (!$result) Return false;
		$this -> Affected = mysql_affected_rows();
		$this -> QueryStatus = '(ok)';
		Return $result;
	}

	/**
	 * 插入数据
	 * @param	string	$table		表名
	 * @param	Array	$data		数据
	 * @return	int 	InsertId	新增ID
	 */
	public function _insert($table, $data)
	{
		$this -> InsertId = 0;
		if (!is_array($data) || count($data) == 0)  Return 0;

		$field_arr = array();
		foreach ($data as $key=>$val)
			$field_arr[] = " `$key` = '$val' ";

		$sql = "INSERT INTO `$table` SET " . implode(',', $field_arr);
		$this -> _query($sql);
		$this -> InsertId = mysql_insert_id();
		Return $this -> InsertId;
	}

	/**
	 * 更新数据
	 * @param	string	$table		表名
	 * @param	Array	$data		数据
	 * @param	string	$where		更新条件
	 * @return	int 	Affected	影响数
	 */
	public function _update($table, $data, $where = '')
	{
		$this -> Affected = 0;
		if (!is_array($data) || count($data) == 0)  Return 0;

		$field_arr = array();
		foreach ($data as $key=>$val)
			$field_arr[] = " `$key` = '$val' ";

		$sql = "UPDATE `$table` SET " . implode(',', $field_arr) . $where;
		$this -> _query($sql);
		Return $this -> Affected;
	}

	/**
	 * 取得一排数据
	 * @param	string	$sql				SQL语句
	 * @param	string	$result_type		类型
	 * @return	Array 	$row				数据
	 */
	public function _row($sql, $result_type = MYSQL_ASSOC) 
	{
		$result = $this -> _query($sql);
		if (!$result) Return false;
		$row = mysql_fetch_array($result, $result_type);
		$this -> ResultSum = 1;
		$this -> _free($result);
		Return $row;
	}

	/**
	 * 取得所有数据
	 * @param	string	$sql				SQL语句
	 * @param	string	$result_type		类型
	 * @return	Array 	$row				数据
	 */
	public function select($sql, $result_type = MYSQL_ASSOC) 
	{
		$result = $this -> _query($sql);
		if (!$result) 
		{
			AirMsg("SQL语句执行错误：$sql <br />" . $this->geterror());
		}
		$data = array();
		$this -> ResultSum = 0;
		while ($row = mysql_fetch_array($result, $result_type))
		{
			$data[] = $row;
			++$this -> ResultSum;
		}
		$this -> _free($result);
		Return $data;
	}
	
	/**
	 * 取得数据总数
	 * @param	string	$sql	SQL语句
	 * @return	int 			数量
	 */
	public function _sum($sql)
	{
		$result = $this -> _query($sql);
		if (!$result) Return false;
		Return mysql_num_rows($result);
	}
	
	/**
	 * 释放结果集
	 * @param	Object	$rs	释放
	 */
	public function _free($rs) 
	{
		Return mysql_free_result($rs);
	}
   /**
	 * 关闭数据库连接
	 */
	function close() {
		return mysql_close($this -> MysqlConnect);
	}

	/**
	 * 发送查询语句
	 *
	 */
	function find($sql) {
		$res = @mysql_query($sql,$this -> MysqlConnect);
		if (!$res) {
			AirMsg("SQL语句执行错误：$sql <br />" . $this->geterror());
		}else {
			$result = $this->fetch_array($res);
			return $result;
		}
	}

	/**
	 * 从结果集中取得一行作为关联数组/数字索引数组
	 *
	 */
	function fetch_array($query , $type = MYSQL_ASSOC) {
		return mysql_fetch_array($query, $type);
	}
    function fetch_assoc($query , $type = MYSQL_ASSOC) {
		return mysql_fetch_assoc($query, $type);
	}
	function once_fetch_array($sql) {
		$this->result = $this->query($sql);
		return $this->fetch_array($this->result);
	}

	/**
	 * 从结果集中取得一行作为数字索引数组
	 *
	 */
	function fetch_row($query) {
		return mysql_fetch_row($query);
	}

	/**
	 * 取得行的数目
	 *
	 */
	function num_rows($query) {
		return mysql_num_rows($query);
	}

	/**
	 * 取得结果集中字段的数目
	 */
	function num_fields($query) {
		return mysql_num_fields($query);
	}
	/**
	 * 取得上一步 INSERT 操作产生的 ID
	 */
	function insert_id() {
		return mysql_insert_id($this -> MysqlConnect);
	}

	/**
	 * 获取mysql错误
	 */
	function geterror() {
		return mysql_error();
	}

	/**
	 * Get number of affected rows in previous MySQL operation
	 */
	function affected_rows() {
		return mysql_affected_rows();
	}

	/**
	 * 取得数据库版本信息
	 */
	function getMysqlVersion() {
		return mysql_get_server_info();
	}

	/**
	 * 取得数据库查询次数
	 */
	function getQueryCount() {
		return $this->queryCount;
	}
}

?>
